/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity.ai.roar;

import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.reaper.ancientnature.api.common.animator.BaseAnimation;
import net.reaper.ancientnature.common.base.BaseAnimal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RoarController<T extends BaseAnimal<T>> {
    public static final UUID SPEED_UUID = UUID.nameUUIDFromBytes("roar-speed-modifier".getBytes(StandardCharsets.UTF_8));
    private static final AttributeModifier SPEED_MODIFIER = new AttributeModifier(SPEED_UUID, "ancientnature:roaring", -10.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private final BaseAnimal<T> animal;
    private int lastTargetTick = 0;
    @Nullable
    private LivingEntity prevTarget = null;
    private boolean hasSpeedUp = false;
    public BaseAnimation roarAnim;

    public RoarController(@NotNull BaseAnimal<T> animal, @NotNull BaseAnimation roarAnim) {
        this.animal = animal;
        this.roarAnim = roarAnim;
    }

    public void tick() {
        if (!this.animal.m_9236_().f_46443_) {
            LivingEntity target = this.animal.m_5448_();
            AttributeInstance speed = this.animal.m_21051_(Attributes.f_22279_);
            if (speed != null) {
                if (!this.animal.isRoaring()) {
                    this.animal.m_6858_(target != null);
                    if (target != null && target != this.prevTarget && this.animal.f_19797_ - this.lastTargetTick >= 160) {
                        this.prevTarget = target;
                        this.startRoar();
                    }
                }
                if (this.animal.isRoaring() && !this.animal.getAnimator().isPlaying(this.roarAnim.getName()) && this.hasSpeedUp) {
                    this.hasSpeedUp = false;
                    speed.m_22130_(SPEED_MODIFIER);
                }
                if (target != null) {
                    this.lastTargetTick = this.animal.f_19797_;
                }
            }
        }
    }

    public void startRoar() {
        AttributeInstance speed;
        if (!this.animal.m_9236_().f_46443_ && (speed = this.animal.m_21051_(Attributes.f_22279_)) != null) {
            if (!this.hasSpeedUp) {
                this.hasSpeedUp = true;
                if (!speed.m_22109_(SPEED_MODIFIER)) {
                    speed.m_22118_(SPEED_MODIFIER);
                }
            }
            this.animal.getAnimator().play(this.roarAnim);
        }
    }
}

