/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity.ai.sleep;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.reaper.ancientnature.AncientNature;
import net.reaper.ancientnature.api.common.animator.BaseAnimation;
import net.reaper.ancientnature.api.common.misc.Cooldown;
import net.reaper.ancientnature.api.common.misc.RandomRunnable;
import net.reaper.ancientnature.common.base.BaseAnimal;
import net.reaper.ancientnature.common.base.BaseSleepingAnimal;
import net.reaper.ancientnature.common.entity.ai.sleep.DefaultWakeUpSource;
import net.reaper.ancientnature.common.entity.ai.sleep.MobWakeUpEvent;
import net.reaper.ancientnature.common.entity.ai.sleep.SleepAnims;
import net.reaper.ancientnature.common.entity.ai.sleep.SleepPeriod;
import net.reaper.ancientnature.common.entity.ai.sleep.WakeUpCause;
import net.reaper.ancientnature.common.entity.ai.sleep.WakeUpSource;
import net.reaper.ancientnature.common.enums.TamableOrders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SleepController<T extends BaseSleepingAnimal<T>> {
    public static final TargetingConditions WAKE_UP_TARGETS = TargetingConditions.m_148353_().m_148355_().m_26888_((Predicate)new Predicate<LivingEntity>(){

        @Override
        public boolean test(@NotNull LivingEntity animal) {
            BaseSleepingAnimal sleeping;
            return animal.m_6084_() && animal instanceof BaseSleepingAnimal && (sleeping = (BaseSleepingAnimal)animal).isSleep();
        }
    });
    @NotNull
    private final T animal;
    @Nullable
    public BaseAnimation down = null;
    @Nullable
    public BaseAnimation rest = null;
    @Nullable
    public BaseAnimation sleep = null;
    @Nullable
    public BaseAnimation fallAsleep = null;
    @Nullable
    public BaseAnimation wakeUp = null;
    @Nullable
    public BaseAnimation up = null;
    public static final int SLEEP_COOLDOWN = 40;
    @NotNull
    private final Params params;
    private final RandomRunnable sleepCycle = new RandomRunnable();
    @Nullable
    private WakeUpSource lastWakeUpSource = null;
    private boolean wasSleeping = false;
    @NotNull
    private final Cooldown sleepCooldown = new Cooldown(40);
    private boolean wasSitting = false;

    public SleepController(@NotNull T animal, @NotNull Params params) {
        this.animal = animal;
        this.sleepCycle.addAction(new RandomRunnable.Action(0.6f, 40, new Runnable(){
            final /* synthetic */ BaseSleepingAnimal val$animal;
            {
                this.val$animal = baseSleepingAnimal;
            }

            @Override
            public void run() {
                if (SleepController.this.canSleep() && !this.val$animal.isSleep()) {
                    SleepController.this.sleep();
                    AncientNature.LOGGER.info("Animal on pos: {}, start sleeping at: {}", (Object)this.val$animal.m_20182_(), (Object)(this.val$animal.m_9236_().m_46468_() % 24000L));
                }
            }
        })).addAction(new RandomRunnable.Action(0.6f, 40, new Runnable(){
            final /* synthetic */ BaseSleepingAnimal val$animal;
            final /* synthetic */ Params val$params;
            {
                this.val$animal = baseSleepingAnimal;
                this.val$params = params;
            }

            @Override
            public void run() {
                if (this.val$animal.isSleep() && !this.val$params.period.shouldSleep(this.val$animal.m_9236_())) {
                    SleepController.this.wakeUp(WakeUpCause.TIME, null);
                    AncientNature.LOGGER.info("Animal on pos: {}, woke up due to sleep period end at: {}", (Object)this.val$animal.m_20182_(), (Object)(this.val$animal.m_9236_().m_46468_() % 24000L));
                }
            }
        }));
        this.params = params;
    }

    @NotNull
    public SleepController<T> setAnims(@Nullable SleepAnims anims) {
        if (anims != null) {
            this.down = anims.down;
            this.rest = anims.rest;
            this.sleep = anims.sleep;
            this.fallAsleep = anims.fallAsleep;
            this.wakeUp = anims.wakeUp;
            this.up = anims.up;
        }
        return this;
    }

    public void onStartSleeping() {
    }

    public void onStopSleeping() {
    }

    @NotNull
    public SleepController<T> wakeUp(@NotNull WakeUpCause cause, @Nullable Entity source) {
        if (!this.animal.m_9236_().f_46443_) {
            MinecraftForge.EVENT_BUS.post((Event)new MobWakeUpEvent((LivingEntity)this.animal, cause, source));
            this.lastWakeUpSource = new DefaultWakeUpSource(cause, source);
            this.sleepCooldown.reset(this.animal.m_217043_().m_216332_(80, 160));
            ((BaseSleepingAnimal)this.animal).setSleep(false);
            AncientNature.LOGGER.debug("{} woke up: {}", (Object)this.animal.m_7755_().getString(), (Object)this.lastWakeUpSource.describe());
        }
        return this;
    }

    @NotNull
    public SleepController<T> sleep() {
        if (!this.animal.m_9236_().f_46443_) {
            ((BaseSleepingAnimal)this.animal).setSleep(true);
            AncientNature.LOGGER.debug("start sleeping: {}", (Object)this.animal.m_7755_().getString());
        }
        return this;
    }

    @NotNull
    public Cooldown getSleepCooldown() {
        return this.sleepCooldown;
    }

    @NotNull
    public Params getParams() {
        return this.params;
    }

    @NotNull
    public SleepController<T> alertOthers(@NotNull WakeUpCause cause, @NotNull Vec3 pos, float radius) {
        AABB area = new AABB(pos, pos).m_82400_((double)radius);
        this.animal.m_9236_().m_6443_(BaseSleepingAnimal.class, area, entity -> WAKE_UP_TARGETS.m_26885_(this.animal, (LivingEntity)entity)).forEach(animal -> animal.sleep.wakeUp(cause, (Entity)this.animal));
        return this;
    }

    public boolean canSleep() {
        if (this.animal.m_20160_()) {
            return false;
        }
        if (this.animal.m_5448_() != null) {
            return false;
        }
        if (!this.animal.m_21573_().m_26571_()) {
            return false;
        }
        return this.params.canSleep && this.params.period.shouldSleep(this.animal.m_9236_()) && this.sleepCooldown.isReady();
    }

    public boolean isCanWakeUp() {
        return !this.canSleep() && ((BaseSleepingAnimal)this.animal).m_5803_();
    }

    @Nullable
    public WakeUpCause getLastWakeUpCause() {
        return this.lastWakeUpSource != null ? this.lastWakeUpSource.cause() : null;
    }

    @Nullable
    public Entity getWakeUpEntity() {
        return this.lastWakeUpSource != null ? this.lastWakeUpSource.entity() : null;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SleepController {\n");
        sb.append(" Animal: ").append(this.animal.m_7755_().getString()).append(",\n");
        sb.append(" Position: ").append(this.animal.m_20182_()).append(",\n");
        sb.append(" Level DayTime: ").append(this.animal.m_9236_().m_46468_()).append(",\n");
        sb.append(" Sleeping: ").append(((BaseSleepingAnimal)this.animal).m_5803_()).append(",\n");
        sb.append(" Was Sleeping: ").append(this.wasSleeping).append(",\n");
        sb.append(" SleepCooldown Ready: ").append(this.sleepCooldown.isReady()).append(",\n");
        sb.append(" Can Sleep: ").append(this.canSleep()).append(",\n");
        sb.append(" Can Wake Up: ").append(this.isCanWakeUp()).append(",\n");
        sb.append(" Last WakeUp Cause: ").append(this.lastWakeUpSource != null ? this.lastWakeUpSource.describe() : "None").append(",\n");
        sb.append(" Params: ").append(this.params).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public boolean lieDownOrSleep(boolean sleep) {
        if (sleep) {
            if (this.wasSitting) {
                this.fallAsleep.setNextAnimation(this.sleep.getName());
                ((BaseAnimal)this.animal).getAnimator().play(this.fallAsleep);
            } else {
                this.down.setNextAnimation(this.fallAsleep.getName());
                this.fallAsleep.setNextAnimation(this.sleep.getName());
                ((BaseAnimal)this.animal).getAnimator().play(this.down);
            }
            this.wasSitting = false;
            ((BaseSleepingAnimal)this.animal).setRest(false);
        } else if (this.down != null && this.rest != null) {
            this.down.setNextAnimation(this.rest.getName());
            this.rest.setNextAnimation(null);
            ((BaseAnimal)this.animal).getAnimator().play(this.down);
            ((BaseSleepingAnimal)this.animal).setRest(true);
            this.wasSitting = true;
        }
        return true;
    }

    public boolean standOrWakeUp(boolean wakeUp) {
        if (wakeUp) {
            if (this.wasSitting || ((BaseAnimal)this.animal).getOrder() == TamableOrders.SIT) {
                this.wakeUp.setNextAnimation(this.rest.getName());
                this.rest.setNextAnimation(null);
                ((BaseAnimal)this.animal).getAnimator().play(this.wakeUp);
                ((BaseSleepingAnimal)this.animal).setRest(true);
                this.wasSitting = true;
            } else {
                this.wakeUp.setNextAnimation(this.up.getName());
                this.up.setNextAnimation(null);
                ((BaseAnimal)this.animal).getAnimator().play(this.wakeUp);
                ((BaseSleepingAnimal)this.animal).setRest(false);
                this.wasSitting = false;
            }
        } else {
            ((BaseAnimal)this.animal).getAnimator().play(this.up);
            ((BaseSleepingAnimal)this.animal).setRest(false);
            this.wasSitting = false;
        }
        return true;
    }

    public void update() {
        boolean shouldSit;
        boolean moving;
        this.sleepCycle.update();
        this.sleepCooldown.tickAndCheck();
        boolean sleeping = ((BaseSleepingAnimal)this.animal).isSleep();
        boolean sittingOrder = ((BaseAnimal)this.animal).getOrder() == TamableOrders.SIT;
        boolean passenger = this.animal.m_20159_();
        boolean bl = moving = !this.animal.m_21573_().m_26571_();
        if (sleeping && !this.wasSleeping) {
            this.lieDownOrSleep(true);
            this.onStartSleeping();
        } else if (!sleeping && this.wasSleeping) {
            this.standOrWakeUp(true);
            this.onStopSleeping();
        }
        this.wasSleeping = sleeping;
        if (sleeping) {
            this.wasSitting = false;
            ((BaseSleepingAnimal)this.animal).setRest(false);
            return;
        }
        boolean bl2 = shouldSit = sittingOrder && !passenger && !moving;
        if (shouldSit && !this.wasSitting) {
            if (this.down != null && this.rest != null) {
                this.down.setNextAnimation(this.rest.getName());
                this.rest.setNextAnimation(null);
                ((BaseAnimal)this.animal).getAnimator().play(this.down);
            }
            ((BaseSleepingAnimal)this.animal).setRest(true);
        } else if (!shouldSit && this.wasSitting) {
            if (this.up != null) {
                this.up.setNextAnimation(null);
                ((BaseAnimal)this.animal).getAnimator().play(this.up);
            }
            ((BaseSleepingAnimal)this.animal).setRest(false);
        }
        this.wasSitting = shouldSit;
    }

    public record Params(boolean canSleep, boolean canRest, @NotNull SleepPeriod period) {
        @Override
        @NotNull
        public String toString() {
            return String.format("Can sleep: %s, Can rest: %s, Sleep period: %s", new Object[]{this.canSleep, this.canRest, this.period});
        }
    }

    @Mod.EventBusSubscriber(modid="ancientnature")
    private static class Events {
        private Events() {
        }

        @SubscribeEvent
        public static void onLivingHurt(@NotNull LivingHurtEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof BaseSleepingAnimal) {
                BaseSleepingAnimal animal = (BaseSleepingAnimal)livingEntity;
                SleepController sleep = animal.sleep;
                if (sleep != null && animal.isSleep()) {
                    sleep.wakeUp(WakeUpCause.DAMAGE, event.getSource().m_7639_());
                }
            }
        }

        @SubscribeEvent
        public static void onExplosionDetonate(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ExplosionEvent.Detonate event) {
            Level level = event.getLevel();
            if (!level.f_46443_) {
                AABB area = new AABB(BlockPos.m_274446_((Position)event.getExplosion().getPosition())).m_82400_(15.0);
                level.m_6443_(BaseSleepingAnimal.class, area, animal -> animal.m_6084_() && animal.isSleep()).forEach(animal -> {
                    if (animal.sleep != null) {
                        animal.sleep.wakeUp(WakeUpCause.EXPLOSION, null);
                    }
                });
            }
        }
    }
}

