/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity.ai.sleep;

import net.minecraft.world.level.Level;
import net.minecraftforge.common.IExtensibleEnum;
import org.jetbrains.annotations.NotNull;

public enum SleepPeriod implements IExtensibleEnum
{
    DAY(new Condition(){

        @Override
        public boolean shouldSleep(@NotNull Level level) {
            long time = level.m_46468_() % 24000L;
            return time >= 12000L;
        }
    }),
    NIGHT(new Condition(){

        @Override
        public boolean shouldSleep(@NotNull Level level) {
            long time = level.m_46468_() % 24000L;
            return time >= 0L && time < 12000L;
        }
    }),
    MIDTIME(new Condition(){

        @Override
        public boolean shouldSleep(@NotNull Level level) {
            long time = level.m_46468_() % 24000L;
            return time >= 18000L || time >= 0L && time < 6000L;
        }
    });

    private final Condition condition;

    private SleepPeriod(Condition logic) {
        this.condition = logic;
    }

    public boolean shouldSleep(@NotNull Level level) {
        return this.condition.shouldSleep(level);
    }

    @NotNull
    public static SleepPeriod create(String name, Condition condition) {
        throw new IllegalStateException("Enum not extended: " + name);
    }

    @FunctionalInterface
    public static interface Condition {
        public boolean shouldSleep(@NotNull Level var1);
    }
}

