/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.event;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.reaper.ancientnature.AncientNature;
import net.reaper.ancientnature.api.common.tag.IEntityData;
import net.reaper.ancientnature.common.entity.AnomalocarisEntity;
import net.reaper.ancientnature.common.entity.DodoEntity;
import net.reaper.ancientnature.common.entity.JakapilEntity;
import net.reaper.ancientnature.common.entity.ThylacineEntity;
import net.reaper.ancientnature.common.entity.TrilobiteEntity;
import net.reaper.ancientnature.common.entity.ai.goal.vanilla.PigDestroyDodoEggsGoal;
import net.reaper.ancientnature.core.registry.ANAdvancementsRegistry;
import net.reaper.ancientnature.core.registry.ANItems;
import net.reaper.ancientnature.core.registry.ANMobEffects;
import net.reaper.ancientnature.core.util.ANUtils;
import org.jetbrains.annotations.NotNull;
import org.jline.utils.Log;

@Mod.EventBusSubscriber
public class ANCommonEvents {
    private static final Map<UUID, Integer> trackedEntities = new HashMap<UUID, Integer>();

    @SubscribeEvent
    public static void onTargetChange(@NotNull LivingChangeTargetEvent event) {
        int fear;
        PathfinderMob mob;
        CompoundTag tag;
        LivingEntity attacker = event.getEntity();
        if (attacker instanceof PathfinderMob && (tag = IEntityData.get((Entity)(mob = (PathfinderMob)attacker))).m_128441_("JakapilFear") && (fear = tag.m_128451_("JakapilFear")) > 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingTickEvent(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LivingEvent.LivingTickEvent event) {
        int fear;
        PathfinderMob mob;
        CompoundTag tag;
        LivingEntity entity = event.getEntity();
        if (entity instanceof PathfinderMob && (tag = IEntityData.get((Entity)(mob = (PathfinderMob)entity))).m_128441_("JakapilFear") && (fear = tag.m_128451_("JakapilFear")) > 0) {
            Vec3 posAway;
            AABB aabb = mob.m_20191_().m_82377_(15.0, 7.0, 15.0);
            JakapilEntity jakapil = (JakapilEntity)mob.m_9236_().m_45982_(mob.m_9236_().m_45976_(JakapilEntity.class, aabb), TargetingConditions.m_148353_(), null, mob.m_20185_(), mob.m_20186_(), mob.m_20189_());
            if (jakapil != null && (posAway = LandRandomPos.m_148521_((PathfinderMob)mob, (int)15, (int)10, (Vec3)jakapil.m_20182_())) != null) {
                mob.m_21573_().m_26519_(posAway.f_82479_, posAway.f_82480_, posAway.f_82481_, (double)1.1f);
            }
            tag.m_128405_("JakapilFear", fear - 1);
        }
    }

    @SubscribeEvent
    public static void onLivingEntityUseItemFinish(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LivingEntityUseItemEvent.Finish event) {
        LivingEntity eater = event.getEntity();
        Level level = eater.m_9236_();
        if (!level.f_46443_ && event.getItem().m_150930_(Items.f_42575_) && event.getResultStack().m_41619_()) {
            AABB area = new AABB(eater.m_20183_()).m_82377_(5.0, 5.0, 5.0);
            level.m_6443_(DodoEntity.class, area, dodo -> dodo.m_6084_() && dodo.m_142582_((Entity)eater) && !dodo.isSleep()).forEach(dodo -> dodo.getAnimator().play(dodo.screamAnim));
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(@NotNull EntityJoinLevelEvent event) {
        Pig pig;
        Entity entity;
        Level level = event.getLevel();
        if (!level.f_46443_ && (entity = event.getEntity()) instanceof Pig && (pig = (Pig)entity).m_6095_() == EntityType.f_20510_) {
            try {
                pig.f_21345_.m_25352_(3, (Goal)new PigDestroyDodoEggsGoal((PathfinderMob)pig, 1.0, 3));
            }
            catch (Exception e) {
                Log.info((Object[])new Object[]{"Tried to add unique behaviors to vanilla mobs and encountered an error"});
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Level level = player.m_9236_();
        if (event.phase == TickEvent.Phase.END && !level.f_46443_) {
            if (player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ANItems.SCARY_SKULL.get())) {
                AABB aabb = player.m_20191_().m_82400_(10.0);
                level.m_6443_(LivingEntity.class, aabb, target -> target != player && ANUtils.isEntityInFront((LivingEntity)player, target, Math.toRadians(45.0))).forEach(target -> {
                    UUID uuid = target.m_20148_();
                    int timeLooking = trackedEntities.getOrDefault(uuid, 0) + 1;
                    trackedEntities.put(uuid, timeLooking);
                    int fearLevel = Math.min(timeLooking / 100, 2);
                    target.m_7292_(new MobEffectInstance((MobEffect)ANMobEffects.FEAR.get(), 100 + fearLevel * 100, fearLevel, false, false, true));
                });
                trackedEntities.keySet().removeIf(id -> {
                    Entity entity = ANUtils.getEntityByUUID(level, id);
                    if (entity instanceof Mob) {
                        Mob mob = (Mob)entity;
                        return !ANUtils.isEntityInFront((LivingEntity)player, (LivingEntity)mob, Math.toRadians(45.0));
                    }
                    return false;
                });
            }
            if (event.player.f_19797_ % 40 == 0) {
                ANCommonEvents.checkProximityToDino(player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerWakeUp(PlayerWakeUpEvent event) {
        AncientNature.LOGGER.info("Player woke up");
        if (!event.getEntity().m_9236_().m_5776_()) {
            AncientNature.LOGGER.info("Server Side wakeup");
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                BlockPos playerPos = player2.m_20183_();
                long timeOfDay = player2.m_9236_().m_46468_();
                if (timeOfDay <= 23550L) {
                    return;
                }
                RandomSource random = player2.m_9236_().m_213780_();
                List nearbyThylacines = player2.m_9236_().m_6443_(ThylacineEntity.class, new AABB(playerPos).m_82400_(15.0), entity -> entity.m_21824_() && entity.m_269323_() == player2);
                for (ThylacineEntity thylacine : nearbyThylacines) {
                    ItemStack drop = ANCommonEvents.getDropForBiomeAndSearchState((Holder<Biome>)player2.m_9236_().m_204166_(playerPos), thylacine, random);
                    thylacine.m_19983_(drop);
                }
            }
        }
    }

    private static ItemStack getDropForBiomeAndSearchState(Holder<Biome> biome, ThylacineEntity thylacine, RandomSource random) {
        Item searchTarget = thylacine.getIsSearchingFor();
        if (searchTarget != null) {
            float chance;
            boolean isRare = ANCommonEvents.isRareItem(searchTarget);
            float f = chance = isRare ? 0.15f : 0.3f;
            if (random.m_188501_() < chance) {
                return new ItemStack((ItemLike)searchTarget);
            }
        }
        return ANCommonEvents.getDefaultDropForBiome(biome, random);
    }

    private static boolean isRareItem(Item item) {
        return item == Items.f_42417_ || item == Items.f_42413_ || item == Items.f_42451_;
    }

    private static ItemStack getDefaultDropForBiome(Holder<Biome> biome, RandomSource random) {
        if (random.m_188501_() < 0.1f) {
            return switch (random.m_188503_(4)) {
                case 0 -> new ItemStack((ItemLike)Items.f_42417_);
                case 1 -> new ItemStack((ItemLike)Items.f_42413_);
                case 2 -> new ItemStack((ItemLike)Items.f_42451_);
                default -> new ItemStack((ItemLike)Items.f_42500_);
            };
        }
        if (biome.m_203656_(BiomeTags.f_207609_)) {
            return ANCommonEvents.getCommonDrop(random, Items.f_42780_, Items.f_42398_);
        }
        if (biome.m_203656_(BiomeTags.f_207611_)) {
            return ANCommonEvents.getCommonDrop(random, Items.f_41870_, Items.f_42403_);
        }
        if (biome.m_203656_(Tags.Biomes.IS_DESERT)) {
            return ANCommonEvents.getCommonDrop(random, Items.f_42403_, Items.f_41909_, Items.f_41982_);
        }
        return ANCommonEvents.getCommonDrop(random, Items.f_42401_, Items.f_42500_, Items.f_42398_);
    }

    private static ItemStack getCommonDrop(RandomSource random, Item ... items) {
        return new ItemStack((ItemLike)items[random.m_188503_(items.length)]);
    }

    private static void checkProximityToDino(@NotNull Player player) {
        Level level = player.m_9236_();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        AABB aabb = new AABB(player.m_20183_()).m_82400_(10.0);
        level.m_45976_(AnomalocarisEntity.class, aabb).forEach(anomalocaris -> ANAdvancementsRegistry.THE_FIRST_APEX.trigger(serverPlayer));
        level.m_45976_(TrilobiteEntity.class, aabb).forEach(trilobites -> ANAdvancementsRegistry.CAMBRIAN_ARMADILLO.trigger(serverPlayer));
        level.m_45976_(TrilobiteEntity.class, aabb).forEach(trilobites -> {
            if (trilobites.isHiding()) {
                ANAdvancementsRegistry.ROLY_POLY.trigger(serverPlayer);
            }
        });
        level.m_45976_(TrilobiteEntity.class, aabb).forEach(trilobites -> {
            if (trilobites.getVariant() == 0 && trilobites.getVariant() == 1 && trilobites.getVariant() == 2 && trilobites.getVariant() == 3) {
                ANAdvancementsRegistry.GOTTA_CATCH_EM_ALL.trigger(serverPlayer);
            }
        });
        level.m_45976_(TrilobiteEntity.class, aabb).forEach(trilobites -> {
            if (trilobites.getVariant() == 3) {
                ANAdvancementsRegistry.THE_BLUE_ONE.trigger(serverPlayer);
            }
        });
        level.m_45976_(ThylacineEntity.class, aabb).forEach(thylacine -> ANAdvancementsRegistry.ITS_ALIVE.trigger(serverPlayer));
        level.m_45976_(ThylacineEntity.class, aabb).forEach(thylacine -> {
            if (player.m_9236_().m_5776_() && thylacine.m_21824_() && thylacine.getIsSearchingFor() == Items.f_42780_ || thylacine.getIsSearchingFor() == Items.f_41870_ || thylacine.getIsSearchingFor() == Items.f_42403_ || thylacine.getIsSearchingFor() == Items.f_41909_ || thylacine.getIsSearchingFor() == Items.f_41982_ || thylacine.getIsSearchingFor() == Items.f_42398_) {
                ANAdvancementsRegistry.MODERN_SNIFFER.trigger(serverPlayer);
            }
        });
    }
}

