/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.reaper.ancientnature.common.recipe.BrushingRecipe;
import net.reaper.ancientnature.common.recipe.WaterWashingRecipe;
import net.reaper.ancientnature.core.registry.ANItems;
import net.reaper.ancientnature.core.registry.ANParticles;
import net.reaper.ancientnature.core.registry.ANRecipes;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(modid="ancientnature", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BrushControlEvents {
    @SubscribeEvent
    public static void rightCLick(PlayerInteractEvent.RightClickItem event) {
        BlockHitResult blockhitresult = BrushControlEvents.getPlayerPOVHitResult(event.getLevel(), event.getEntity(), ClipContext.Fluid.SOURCE_ONLY);
        if (blockhitresult.m_6662_() == HitResult.Type.BLOCK && event.getLevel().m_6425_(blockhitresult.m_82425_()).m_192917_((Fluid)Fluids.f_76193_) || BrushControlEvents.isWaterBottle(event.getEntity().m_21206_()) || BrushControlEvents.isWaterBottle(event.getEntity().m_21205_())) {
            if (!BrushControlEvents.handleWaterBrushing(event, blockhitresult.m_6662_() == HitResult.Type.BLOCK && event.getLevel().m_6425_(blockhitresult.m_82425_()).m_192917_((Fluid)Fluids.f_76193_))) {
                BrushControlEvents.handleBrushing(event);
            }
        } else {
            BrushControlEvents.handleBrushing(event);
        }
    }

    protected static void handleBrushing(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        if (player.m_36335_().m_41519_(Items.f_271356_)) {
            return;
        }
        SimpleContainer hands = new SimpleContainer(new ItemStack[]{player.m_21205_(), player.m_21206_()});
        ArrayList<BrushingRecipe> recipes = new ArrayList<BrushingRecipe>(event.getLevel().m_7465_().m_44013_((RecipeType)ANRecipes.BRUSHING_RECIPE.get()));
        if (!recipes.isEmpty()) {
            recipes.removeIf(arg_0 -> BrushControlEvents.lambda$handleBrushing$0((Container)hands, event, arg_0));
            Collections.shuffle(recipes);
            Iterator iterator = recipes.iterator();
            if (iterator.hasNext()) {
                BrushingRecipe recipe = (BrushingRecipe)iterator.next();
                player.m_36335_().m_41524_(Items.f_271356_, 15);
                boolean willBreak = false;
                float breakingChance = 0.1f;
                if (event.getLevel().f_46441_.m_188501_() < breakingChance) {
                    willBreak = true;
                }
                if (recipe.getBrush().test(player.m_21206_())) {
                    player.m_6674_(InteractionHand.OFF_HAND);
                    player.m_21206_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.OFF_HAND));
                    player.m_21205_().m_41774_(1);
                } else {
                    player.m_6674_(InteractionHand.MAIN_HAND);
                    player.m_21205_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
                    player.m_21206_().m_41774_(1);
                }
                if (willBreak) {
                    event.getLevel().m_5594_(null, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    return;
                }
                ItemStack stack = recipe.m_5874_((Container)hands, event.getLevel().m_9598_());
                if (!stack.m_41619_()) {
                    stack.m_41764_(1);
                    BrushControlEvents.addOrDropStack(player, stack);
                }
                event.getLevel().m_5594_(null, player.m_20183_(), SoundEvents.f_276624_, SoundSource.PLAYERS, 1.0f, 1.0f);
                BrushControlEvents.spawnDustParticles(event.getLevel(), player);
                return;
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    public static boolean handleWaterBrushing(PlayerInteractEvent.RightClickItem event, boolean selectingWater) {
        ArrayList<WaterWashingRecipe> finalRecipes;
        Player player = event.getEntity();
        if (player.m_36335_().m_41519_((Item)ANItems.MUDDY_FOSSIL.get())) {
            return false;
        }
        player.m_36335_().m_41524_((Item)ANItems.MUDDY_FOSSIL.get(), 15);
        if (selectingWater) {
            recipes = new ArrayList<WaterWashingRecipe>(event.getLevel().m_7465_().m_44013_((RecipeType)ANRecipes.WATER_WASHING.get()));
            recipes.removeIf(r -> !r.m_5818_((Container)new SimpleContainer(new ItemStack[]{event.getEntity().m_21205_()}), event.getLevel()) && !r.m_5818_((Container)new SimpleContainer(new ItemStack[]{event.getEntity().m_21206_()}), event.getLevel()));
            finalRecipes = recipes;
        } else if (BrushControlEvents.isWaterBottle(event.getEntity().m_21206_())) {
            recipes = new ArrayList(event.getLevel().m_7465_().m_44013_((RecipeType)ANRecipes.WATER_WASHING.get()));
            recipes.removeIf(r -> !r.m_5818_((Container)new SimpleContainer(new ItemStack[]{event.getEntity().m_21205_()}), event.getLevel()));
            finalRecipes = recipes;
        } else {
            recipes = new ArrayList(event.getLevel().m_7465_().m_44013_((RecipeType)ANRecipes.WATER_WASHING.get()));
            recipes.removeIf(r -> !r.m_5818_((Container)new SimpleContainer(new ItemStack[]{event.getEntity().m_21206_()}), event.getLevel()));
            finalRecipes = recipes;
        }
        Collections.shuffle(finalRecipes);
        Iterator iterator = finalRecipes.iterator();
        if (iterator.hasNext()) {
            WaterWashingRecipe recipe = (WaterWashingRecipe)iterator.next();
            ItemStack stack = recipe.m_5874_((Container)new SimpleContainer(new ItemStack[0]), event.getLevel().m_9598_());
            BrushControlEvents.addOrDropStack(event.getEntity(), stack);
            event.getLevel().m_5594_(null, player.m_20183_(), SoundEvents.f_11917_, SoundSource.PLAYERS, 1.0f, 1.0f);
            BrushControlEvents.spawnWaterAndMudParticles(event.getLevel(), player);
            if (!selectingWater) {
                if (BrushControlEvents.isWaterBottle(event.getEntity().m_21206_())) {
                    event.getEntity().m_21008_(InteractionHand.OFF_HAND, Items.f_42590_.m_7968_());
                    event.getEntity().m_21205_().m_41774_(1);
                } else {
                    event.getEntity().m_21008_(InteractionHand.MAIN_HAND, Items.f_42590_.m_7968_());
                    event.getEntity().m_21206_().m_41774_(1);
                }
            } else {
                event.getItemStack().m_41774_(1);
            }
            return true;
        }
        if (!finalRecipes.isEmpty()) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            return true;
        }
        return false;
    }

    protected static boolean isWaterBottle(ItemStack stack) {
        return stack.m_150930_(Items.f_42589_) && PotionUtils.m_43579_((ItemStack)stack) == Potions.f_43599_;
    }

    protected static BlockHitResult getPlayerPOVHitResult(Level pLevel, Player pPlayer, ClipContext.Fluid pFluidMode) {
        float f = pPlayer.m_146909_();
        float f1 = pPlayer.m_146908_();
        Vec3 vec3 = pPlayer.m_146892_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = pPlayer.getBlockReach();
        Vec3 vec31 = vec3.m_82520_((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return pLevel.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, pFluidMode, (Entity)pPlayer));
    }

    protected static void addOrDropStack(Player player, ItemStack stack) {
        ItemEntity item;
        if (!stack.m_41619_() && !player.m_36356_(stack) && (item = player.m_36176_(stack, false)) != null) {
            player.m_9236_().m_7967_((Entity)item);
        }
    }

    private static void spawnWaterAndMudParticles(Level level, Player player) {
        int i;
        if (!level.f_46443_) {
            return;
        }
        Vec3 playerPos = player.m_20182_();
        Vec3 lookVec = player.m_20154_();
        for (i = 0; i < 7; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123769_, playerPos.f_82479_ + lookVec.f_82479_ * 1.0 + (level.f_46441_.m_188500_() - 0.5) * 0.5, playerPos.f_82480_ + 1.2 + (level.f_46441_.m_188500_() - 0.5) * 0.2, playerPos.f_82481_ + lookVec.f_82481_ * 1.0 + (level.f_46441_.m_188500_() - 0.5) * 0.5, lookVec.f_82479_ * 0.1, 0.1, lookVec.f_82481_ * 0.1);
        }
        for (i = 0; i < 7; ++i) {
            level.m_7106_((ParticleOptions)ANParticles.MUD_PARTICLE.get(), playerPos.f_82479_ + lookVec.f_82479_ * 1.0 + (level.f_46441_.m_188500_() - 0.5) * 0.5, playerPos.f_82480_ + 1.2 + (level.f_46441_.m_188500_() - 0.5) * 0.2, playerPos.f_82481_ + lookVec.f_82481_ * 1.0 + (level.f_46441_.m_188500_() - 0.5) * 0.5, lookVec.f_82479_ * 0.1, 0.1, lookVec.f_82481_ * 0.1);
        }
    }

    private static void spawnDustParticles(Level level, Player player) {
        if (!level.f_46443_) {
            return;
        }
        Vec3 playerPos = player.m_20182_();
        Vec3 lookVec = player.m_20154_();
        DustParticleOptions dustParticle = new DustParticleOptions(new Vector3f(0.5f, 0.5f, 0.5f), 1.0f);
        for (int i = 0; i < 10; ++i) {
            level.m_7106_((ParticleOptions)ANParticles.STONE_PARTICLE.get(), playerPos.f_82479_ + lookVec.f_82479_ * 1.0 + (level.f_46441_.m_188500_() - 0.5) * 0.5, playerPos.f_82480_ + 1.5 + (level.f_46441_.m_188500_() - 0.5) * 0.2, playerPos.f_82481_ + lookVec.f_82481_ * 1.0 + (level.f_46441_.m_188500_() - 0.5) * 0.5, lookVec.f_82479_ * 0.1, 0.1, lookVec.f_82481_ * 0.1);
        }
    }

    private static /* synthetic */ boolean lambda$handleBrushing$0(Container hands, PlayerInteractEvent.RightClickItem event, BrushingRecipe r) {
        return !r.m_5818_(hands, event.getLevel());
    }
}

