/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.reaper.ancientnature.core.config.AncientNatureConfig;

@Mod.EventBusSubscriber
public class CameraShakeManager {
    private static final Random RANDOM = new Random();
    private static final Map<Player, ShakeData> shakingPlayers = new HashMap<Player, ShakeData>();

    public static void init() {
        MinecraftForge.EVENT_BUS.register(CameraShakeManager.class);
    }

    public static void applyCameraShake(ServerPlayer player, int duration, float intensity) {
        if (((Boolean)AncientNatureConfig.CAMERASHAKE.get()).booleanValue()) {
            shakingPlayers.put((Player)player, new ShakeData(duration, intensity));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && shakingPlayers.containsKey(event.player)) {
            if (!((Boolean)AncientNatureConfig.CAMERASHAKE.get()).booleanValue()) {
                shakingPlayers.remove(event.player);
                return;
            }
            ShakeData shakeData = shakingPlayers.get(event.player);
            float yawShake = (RANDOM.nextFloat() - 0.5f) * shakeData.intensity;
            float pitchShake = (RANDOM.nextFloat() - 0.5f) * shakeData.intensity;
            float currentYaw = event.player.m_146908_();
            float currentPitch = event.player.m_146909_();
            float targetYaw = currentYaw + yawShake;
            float targetPitch = currentPitch + pitchShake;
            float lerpedYaw = Mth.m_14179_((float)0.5f, (float)currentYaw, (float)targetYaw);
            float lerpedPitch = Mth.m_14179_((float)0.5f, (float)currentPitch, (float)targetPitch);
            event.player.m_146922_(lerpedYaw);
            event.player.m_146926_(lerpedPitch);
            --shakeData.duration;
            if (shakeData.duration <= 0) {
                shakingPlayers.remove(event.player);
            }
        }
    }

    private static class ShakeData {
        int duration;
        float intensity;

        public ShakeData(int duration, float intensity) {
            this.duration = duration;
            this.intensity = intensity;
        }
    }
}

