/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.goals;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.reaper.ancientnature.common.base.BaseAnimal;

public class ANFollowOwnerGoal
extends Goal {
    private final BaseAnimal animal;
    private LivingEntity owner;
    private final LevelReader level;
    private final double walkSpeedModifier;
    private final double sprintSpeedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float sprintDistance;
    private final float teleportDistance;
    private final float stopDistance;
    private float oldWaterCost;
    private final boolean canFly;

    public ANFollowOwnerGoal(BaseAnimal pAnimal, double pWalkSpeedModifier, double pSprintSpeedModifier, float pSprintDistance, float pTeleportDistance, float pStopDistance, boolean pCanFly) {
        this.animal = pAnimal;
        this.level = pAnimal.m_9236_();
        this.walkSpeedModifier = pWalkSpeedModifier;
        this.sprintSpeedModifier = pSprintSpeedModifier;
        this.navigation = pAnimal.m_21573_();
        this.sprintDistance = pSprintDistance;
        this.teleportDistance = pTeleportDistance;
        this.stopDistance = pStopDistance;
        this.canFly = pCanFly;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(pAnimal.m_21573_() instanceof GroundPathNavigation) && !(pAnimal.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for ANFollowOwnerGoal");
        }
    }

    public boolean m_8036_() {
        LivingEntity owner = this.animal.m_269323_();
        if (owner == null) {
            return false;
        }
        if (owner.m_5833_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.animal.m_20280_((Entity)owner) < (double)(this.stopDistance * this.stopDistance)) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean m_8045_() {
        if (this.navigation.m_26571_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        return !(this.animal.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    private boolean unableToMove() {
        return this.animal.cantFollowOwner() || this.animal.m_20159_() || this.animal.m_21523_();
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.animal.m_21439_(BlockPathTypes.WATER);
        this.animal.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.animal.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        this.animal.isSprintingToOwner = false;
    }

    public void m_8037_() {
        this.animal.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.animal.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            if (this.animal.m_20280_((Entity)this.owner) >= (double)(this.teleportDistance * this.teleportDistance)) {
                this.teleportToOwner();
            } else if (this.animal.m_20280_((Entity)this.owner) < (double)(this.sprintDistance * this.sprintDistance) && !this.animal.isSprintingToOwner) {
                this.navigation.m_5624_((Entity)this.owner, this.walkSpeedModifier);
                this.animal.isSprintingToOwner = false;
            } else if (this.animal.m_20280_((Entity)this.owner) >= (double)(this.sprintDistance * this.sprintDistance)) {
                this.navigation.m_5624_((Entity)this.owner, this.sprintSpeedModifier);
                this.animal.isSprintingToOwner = true;
            }
        }
    }

    private void teleportToOwner() {
        BlockPos ownerPos = this.owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int xOffset = this.randomIntInclusive(-3, 3);
            int yOffset = this.randomIntInclusive(-1, 1);
            int zOffset = this.randomIntInclusive(-3, 3);
            boolean teleport = this.maybeTeleportTo(ownerPos.m_123341_() + xOffset, ownerPos.m_123342_() + yOffset, ownerPos.m_123343_() + zOffset);
            if (!teleport) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int pX, int pY, int pZ) {
        if (Math.abs((double)pX - this.owner.m_20185_()) < 2.0 && Math.abs((double)pZ - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(pX, pY, pZ))) {
            return false;
        }
        this.animal.m_7678_((double)pX + 0.5, pY, (double)pZ + 0.5, this.animal.m_146908_(), this.animal.m_146909_());
        this.navigation.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos pPos) {
        BlockPathTypes $$1 = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pPos.m_122032_());
        if ($$1 != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState $$2 = this.level.m_8055_(pPos.m_7495_());
        if (!this.canFly && $$2.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos $$3 = pPos.m_121996_((Vec3i)this.animal.m_20183_());
        return this.level.m_45756_((Entity)this.animal, this.animal.m_20191_().m_82338_($$3));
    }

    private int randomIntInclusive(int pMin, int pMax) {
        return this.animal.m_217043_().m_188503_(pMax - pMin + 1) + pMin;
    }
}

