/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.goals;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class AvoidEntitySprinting<T extends LivingEntity>
extends Goal {
    protected final PathfinderMob mob;
    private final double walkSpeedModifier;
    private final double sprintSpeedModifier;
    @Nullable
    protected T toAvoid;
    protected final float maxDist;
    @Nullable
    protected Path path;
    protected final PathNavigation pathNav;
    protected final Class<T> avoidClass;
    protected final Predicate<LivingEntity> avoidPredicate;
    protected final Predicate<LivingEntity> predicateOnAvoidEntity;
    private final TargetingConditions avoidEntityTargeting;

    public AvoidEntitySprinting(PathfinderMob pMob, Class<T> pEntityClassToAvoid, float pMaxDistance, double pWalkSpeedModifier, double pSprintSpeedModifier) {
        this(pMob, pEntityClassToAvoid, p_25052_ -> true, pMaxDistance, pWalkSpeedModifier, pSprintSpeedModifier, EntitySelector.f_20406_::test);
    }

    public AvoidEntitySprinting(PathfinderMob pMob, Class<T> pEntityClassToAvoid, Predicate<LivingEntity> pAvoidPredicate, float pMaxDistance, double pWalkSpeedModifier, double pSprintSpeedModifier, Predicate<LivingEntity> pPredicateOnAvoidEntity) {
        this.mob = pMob;
        this.avoidClass = pEntityClassToAvoid;
        this.avoidPredicate = pAvoidPredicate;
        this.maxDist = pMaxDistance;
        this.walkSpeedModifier = pWalkSpeedModifier;
        this.sprintSpeedModifier = pSprintSpeedModifier;
        this.predicateOnAvoidEntity = pPredicateOnAvoidEntity;
        this.pathNav = pMob.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.avoidEntityTargeting = TargetingConditions.m_148352_().m_26883_((double)pMaxDistance).m_26888_(pPredicateOnAvoidEntity.and(pAvoidPredicate));
    }

    public AvoidEntitySprinting(PathfinderMob pMob, Class<T> pEntityClassToAvoid, float pMaxDistance, double pWalkSpeedModifier, double pSprintSpeedModifier, Predicate<LivingEntity> pPredicateOnAvoidEntity) {
        this(pMob, pEntityClassToAvoid, p_25049_ -> true, pMaxDistance, pWalkSpeedModifier, pSprintSpeedModifier, pPredicateOnAvoidEntity);
    }

    public boolean m_8036_() {
        this.toAvoid = this.mob.m_9236_().m_45982_(this.mob.m_9236_().m_6443_(this.avoidClass, this.mob.m_20191_().m_82377_((double)this.maxDist, 3.0, (double)this.maxDist), p_148078_ -> true), this.avoidEntityTargeting, (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_());
        if (this.toAvoid == null) {
            return false;
        }
        Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this.mob, (int)16, (int)7, (Vec3)this.toAvoid.m_20182_());
        if (vec3 == null) {
            return false;
        }
        if (this.toAvoid.m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) < this.toAvoid.m_20280_((Entity)this.mob)) {
            return false;
        }
        this.path = this.pathNav.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
        return this.path != null;
    }

    public boolean m_8045_() {
        return !this.pathNav.m_26571_();
    }

    public void m_8056_() {
        this.pathNav.m_26536_(this.path, this.walkSpeedModifier);
    }

    public void m_8041_() {
        this.toAvoid = null;
        this.mob.m_6858_(false);
    }

    public void m_8037_() {
        if (this.mob.m_20280_(this.toAvoid) < 49.0) {
            this.mob.m_21573_().m_26517_(this.sprintSpeedModifier);
            this.mob.m_6858_(true);
        } else {
            this.mob.m_21573_().m_26517_(this.walkSpeedModifier);
            this.mob.m_6858_(false);
        }
    }
}

