/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.goals;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.reaper.ancientnature.AncientNature;
import net.reaper.ancientnature.common.base.BaseAnimal;
import net.reaper.ancientnature.core.registry.ANItems;

public class ConsumeItemFromGroundGoal
extends Goal {
    protected final BaseAnimal mob;
    private final double speedModifier;
    private int range = 8;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private long lastCanUseCheck;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;
    private ItemEntity targetItem;
    private final int eatDelay;
    private final int animationLength;
    private boolean shouldCountTillNextAttack = false;
    private boolean shouldCreateParticles = false;

    public ConsumeItemFromGroundGoal(BaseAnimal pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen, int eatDelay, int animationLength) {
        this.mob = pMob;
        this.speedModifier = pSpeedModifier;
        this.followingTargetEvenIfNotSeen = pFollowingTargetEvenIfNotSeen;
        this.eatDelay = eatDelay;
        this.animationLength = animationLength;
        this.ticksUntilNextAttack = animationLength;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public ConsumeItemFromGroundGoal(BaseAnimal pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen, int eatDelay, int animationLength, int range) {
        this.mob = pMob;
        this.speedModifier = pSpeedModifier;
        this.followingTargetEvenIfNotSeen = pFollowingTargetEvenIfNotSeen;
        this.eatDelay = eatDelay;
        this.animationLength = animationLength;
        this.ticksUntilNextAttack = animationLength;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.range = range;
    }

    public boolean m_8036_() {
        long currentTime = this.mob.m_9236_().m_46467_();
        if (currentTime - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = currentTime;
        if (!this.mob.isHungryEnoughToHunt() || !this.mob.cantFollowOwner()) {
            return false;
        }
        ItemEntity item = this.getTargetItem();
        if (item == null || !item.m_6084_()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.ticksUntilNextPathRecalculation <= 0) {
                this.path = this.mob.m_21573_().m_6570_((Entity)item, 0);
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)item, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(item) >= this.mob.m_20275_(item.m_20185_(), item.m_20186_(), item.m_20189_());
    }

    private ItemEntity getTargetItem() {
        if (this.targetItem != null && this.targetItem.m_6084_()) {
            return this.targetItem;
        }
        List items = this.mob.m_9236_().m_6443_(ItemEntity.class, this.mob.m_20191_().m_82377_((double)this.range, 8.0, (double)this.range), item -> true);
        this.targetItem = items.stream().filter(this::validTarget).min(Comparator.comparingDouble(item -> item.m_20270_((Entity)this.mob))).orElse(null);
        return this.targetItem;
    }

    private boolean validTarget(ItemEntity item) {
        return item.m_6084_() && this.mob.animalDiet.test(item.m_32055_());
    }

    public boolean m_8045_() {
        if (!this.mob.isHungryEnoughToHunt() || !this.mob.cantFollowOwner()) {
            return false;
        }
        ItemEntity item = this.getTargetItem();
        if (item == null || !item.m_6084_()) {
            return false;
        }
        return !this.followingTargetEvenIfNotSeen ? !this.mob.m_21573_().m_26571_() : this.mob.m_21444_(item.m_20183_());
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
        this.ticksUntilNextPathRecalculation = 0;
    }

    public void m_8041_() {
        this.targetItem = null;
        this.mob.m_21573_().m_26573_();
        this.resetAttackCooldown();
        this.shouldCountTillNextAttack = false;
        this.mob.setEating(false);
        this.mob.eatAnimationTimeout = 0;
        this.shouldCreateParticles = false;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        ItemEntity item;
        if (this.shouldCountTillNextAttack) {
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        }
        if ((item = this.getTargetItem()) != null) {
            this.mob.m_21563_().m_24960_((Entity)item, 30.0f, 30.0f);
            double distance = this.mob.m_20270_((Entity)item);
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)item)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || item.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                this.pathedTargetX = item.m_20185_();
                this.pathedTargetY = item.m_20186_();
                this.pathedTargetZ = item.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                if (this.canPenalize) {
                    Node finalPathPoint;
                    this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.mob.m_21573_().m_26570_() != null ? ((finalPathPoint = this.mob.m_21573_().m_26570_().m_77395_()) != null && item.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (distance > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (distance > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.m_21573_().m_5624_((Entity)item, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
                this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
            }
            this.checkAndPerformAttack(item, distance);
            if (this.mob.m_20182_().m_82531_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) <= 0.5) {
                this.shouldCreateParticles = true;
            }
            if (this.shouldCreateParticles) {
                this.calculateAndSpawnItemParticles(item.m_32055_(), 8);
            }
        }
    }

    private void calculateAndSpawnItemParticles(ItemStack pStack, int particlesToCreate) {
        for (int i = 0; i < particlesToCreate; ++i) {
            Vec3 location = ConsumeItemFromGroundGoal.eatingParticleLocation((LivingEntity)this.mob, this.mob.m_9236_().f_46441_);
            Vec3 speed = ConsumeItemFromGroundGoal.eatingParticleSpeed((LivingEntity)this.mob, this.mob.m_9236_().f_46441_);
            this.spawnEatingParticles(this.mob.m_9236_(), pStack, location, speed);
        }
        this.shouldCreateParticles = false;
    }

    private static Vec3 eatingParticleSpeed(LivingEntity entity, RandomSource random) {
        Vec3 speed = new Vec3(((double)random.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
        speed = speed.m_82496_(-entity.m_146909_() * ((float)Math.PI / 180));
        speed = speed.m_82524_(-entity.m_146908_() * ((float)Math.PI / 180));
        return speed;
    }

    private static Vec3 eatingParticleLocation(LivingEntity entity, RandomSource random) {
        double initialYSpeed = (double)(-random.m_188501_()) * 0.6 - 0.3;
        Vec3 location = new Vec3(((double)random.m_188501_() - 0.5) * 0.3, initialYSpeed, 0.6);
        location = location.m_82496_(-entity.m_146909_() * ((float)Math.PI / 180));
        location = location.m_82524_(-entity.m_146908_() * ((float)Math.PI / 180));
        location = location.m_82520_(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
        return location;
    }

    private void spawnEatingParticles(Level level, ItemStack stack, Vec3 location, Vec3 speed) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), location.f_82479_, location.f_82480_, location.f_82481_, 1, speed.f_82479_, speed.f_82480_ + 0.05, speed.f_82481_, 0.0);
        } else {
            level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), location.f_82479_, location.f_82480_, location.f_82481_, speed.f_82479_, speed.f_82480_ + 0.05, speed.f_82481_);
        }
    }

    protected void checkAndPerformAttack(ItemEntity item, double distanceToEnemySqr) {
        if (this.isEnemyWithinAttackDistance(item, distanceToEnemySqr)) {
            this.mob.m_146922_(this.mob.m_6080_());
            this.mob.f_20883_ = this.mob.m_146908_();
            this.mob.m_21573_().m_26573_();
            this.shouldCountTillNextAttack = true;
            if (this.isTimeToStartAttackAnimation()) {
                this.mob.setEating(true);
                this.shouldCreateParticles = true;
            }
            if (this.isTimeToAttack()) {
                Entity entity;
                this.mob.m_21563_().m_24946_(item.m_20185_(), item.m_20188_(), item.m_20189_());
                int currentHunger = this.mob.getTicksUntilHungry();
                this.mob.setTicksUntilHungry(Math.min(6000 + currentHunger, 12000));
                item.m_32055_().m_41764_(item.m_32055_().m_41613_() - 1);
                if (this.mob.m_21824_() && item.m_19749_() == this.mob.m_269323_() && this.mob.m_269323_() instanceof Player && this.mob.m_5957_()) {
                    this.mob.m_27595_((Player)this.mob.m_269323_());
                }
                if (!this.mob.m_21824_() && (entity = item.m_19749_()) instanceof Player) {
                    Player player = (Player)entity;
                    if (this.mob.canBeTamed()) {
                        float chance = this.mob.m_217043_().m_188501_();
                        AncientNature.LOGGER.info("chance: " + chance);
                        if (player.m_6844_(EquipmentSlot.HEAD).m_41720_() == ANItems.TAMERS_HAT.get()) {
                            if (chance > 0.3f) {
                                this.mob.m_21828_(player);
                                Level level = this.mob.m_9236_();
                                if (level instanceof ServerLevel) {
                                    ServerLevel serverLevel = (ServerLevel)level;
                                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.mob.m_20185_(), this.mob.m_20186_() + 0.5, this.mob.m_20189_(), 5, 0.25, 0.25, 0.25, 0.005);
                                }
                            } else {
                                Level level = this.mob.m_9236_();
                                if (level instanceof ServerLevel) {
                                    ServerLevel serverLevel = (ServerLevel)level;
                                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.mob.m_20185_(), this.mob.m_20186_() + 0.5, this.mob.m_20189_(), 5, 0.25, 0.25, 0.25, 0.005);
                                }
                            }
                        } else if (player.m_6844_(EquipmentSlot.HEAD).m_41720_() != ANItems.TAMERS_HAT.get()) {
                            if (chance > 0.65f) {
                                this.mob.m_21828_(player);
                                Level level = this.mob.m_9236_();
                                if (level instanceof ServerLevel) {
                                    ServerLevel serverLevel = (ServerLevel)level;
                                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.mob.m_20185_(), this.mob.m_20186_() + 0.5, this.mob.m_20189_(), 5, 0.25, 0.25, 0.25, 0.005);
                                }
                            } else {
                                Level level = this.mob.m_9236_();
                                if (level instanceof ServerLevel) {
                                    ServerLevel serverLevel = (ServerLevel)level;
                                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.mob.m_20185_(), this.mob.m_20186_() + 0.5, this.mob.m_20189_(), 5, 0.25, 0.25, 0.25, 0.005);
                                }
                            }
                        }
                    }
                }
                this.resetAttackCooldown();
                this.shouldCountTillNextAttack = false;
                this.mob.setEating(false);
                this.mob.eatAnimationTimeout = 0;
                this.shouldCreateParticles = false;
            }
        } else {
            this.resetAttackCooldown();
            this.shouldCountTillNextAttack = false;
            this.mob.setEating(false);
            this.mob.eatAnimationTimeout = 0;
            this.shouldCreateParticles = false;
        }
    }

    protected boolean isTimeToStartAttackAnimation() {
        return this.ticksUntilNextAttack <= this.eatDelay;
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    private boolean isEnemyWithinAttackDistance(ItemEntity item, double distanceToEnemySqr) {
        return distanceToEnemySqr <= this.getAttackReachSqr(item);
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.m_183277_(this.animationLength);
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected double getAttackReachSqr(ItemEntity attackTarget) {
        return (double)this.mob.m_20205_() * 1.2 * (double)this.mob.m_20205_() * 1.2 + (double)attackTarget.m_20205_();
    }
}

