/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.goals;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FishRandomSwimmingGoal
extends Goal {
    protected final Mob mob;
    protected final Set<Class<? extends LivingEntity>> avoidClasses = new HashSet<Class<? extends LivingEntity>>();
    protected final double speedModifier;
    protected final int weights;

    public FishRandomSwimmingGoal(Mob mob, double speedModifier, int weights1) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.weights = weights1;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public FishRandomSwimmingGoal addAvoidClass(Class<? extends LivingEntity> clazz) {
        this.avoidClasses.add(clazz);
        return this;
    }

    public boolean m_8036_() {
        return !this.mob.m_20160_();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26573_();
    }

    public void m_8037_() {
        Vec3 forward = new Vec3(1.0, 0.0, 0.0).m_82524_(-this.mob.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
        Vec3 movement = forward.m_82549_(this.mob.m_20184_().m_82490_((double)this.weights));
        movement = movement.m_82549_(this.getNoise().m_82490_((double)this.weights));
        movement = movement.m_82549_(this.getAwayFromObstacles().m_82490_((double)this.weights));
        movement = movement.m_82549_(this.awayFromEntities().m_82490_((double)this.weights));
        movement = movement.m_82541_();
        float f9 = (float)(Mth.m_14136_((double)movement.f_82479_, (double)movement.f_82481_) * 57.2957763671875) - 90.0f;
        this.mob.m_146922_(FishRandomSwimmingGoal.rotlerp(this.mob.m_146908_(), f9, 90.0f));
        this.mob.m_7910_((float)(this.mob.m_21133_(Attributes.f_22279_) * this.speedModifier));
        this.mob.m_21564_((float)movement.f_82481_);
        this.mob.m_21570_((float)movement.f_82479_);
        this.mob.m_21567_((float)movement.f_82480_);
    }

    protected Vec3 getNoise() {
        double dx = this.mob.m_9236_().f_46441_.m_188583_() * 0.4 - 0.2;
        double dy = this.mob.m_9236_().f_46441_.m_188583_() * 0.4 - 0.2;
        double dz = this.mob.m_9236_().f_46441_.m_188583_() * 0.4 - 0.2;
        return new Vec3(dx, dy, dz);
    }

    protected Vec3 awayFromEntities() {
        if (this.avoidClasses.isEmpty()) {
            return Vec3.f_82478_;
        }
        Vec3 direction = Vec3.f_82478_;
        List entities = this.mob.m_9236_().m_6443_(LivingEntity.class, new AABB(this.mob.m_20097_()).m_82400_(10.0), e -> EntitySelector.f_20406_.test(e) && this.avoidClasses.contains(e.getClass()));
        for (LivingEntity livingEntity : entities) {
            Vec3 avoidEntity = new Vec3(this.mob.m_20185_() - livingEntity.m_20185_(), this.mob.m_20186_() - livingEntity.m_20186_(), this.mob.m_20189_() - livingEntity.m_20189_());
            direction.m_82549_(avoidEntity);
        }
        if (!entities.isEmpty()) {
            direction.m_82490_(1.0 / (double)entities.size());
        }
        return direction;
    }

    protected Vec3 getAwayFromObstacles() {
        AtomicReference<Vec3> directionAtomic = new AtomicReference<Vec3>(Vec3.f_82478_);
        AtomicInteger counter = new AtomicInteger(0);
        BlockPos.m_121921_((AABB)new AABB(this.mob.m_20097_()).m_82400_(10.0)).forEach(pos -> {
            if (!this.canSwim((BlockPos)pos)) {
                Vec3 avoiding = new Vec3(this.mob.m_20185_() - (double)pos.m_123341_(), this.mob.m_20186_() - (double)pos.m_123342_(), this.mob.m_20189_() - (double)pos.m_123343_());
                directionAtomic.set(new Vec3(((Vec3)directionAtomic.get()).f_82479_ + avoiding.f_82479_, ((Vec3)directionAtomic.get()).f_82480_ + avoiding.f_82480_, ((Vec3)directionAtomic.get()).f_82481_ + avoiding.f_82481_));
                counter.incrementAndGet();
            }
        });
        Vec3 direction = directionAtomic.get();
        if (counter.get() > 0) {
            direction.m_82490_(1.0 / (double)counter.get());
        }
        return direction;
    }

    protected boolean canSwim(BlockPos pos) {
        BlockState state = this.mob.m_9236_().m_8055_(pos);
        FluidState fluidSTate = this.mob.m_9236_().m_6425_(pos);
        if (!fluidSTate.m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        return state.m_60812_((BlockGetter)this.mob.m_9236_(), pos).m_83281_();
    }

    protected static float rotlerp(float pSourceAngle, float pTargetAngle, float pMaximumChange) {
        float f1;
        float f = Mth.m_14177_((float)(pTargetAngle - pSourceAngle));
        if (f > pMaximumChange) {
            f = pMaximumChange;
        }
        if (f < -pMaximumChange) {
            f = -pMaximumChange;
        }
        if ((f1 = pSourceAngle + f) < 0.0f) {
            f1 += 360.0f;
        } else if (f1 > 360.0f) {
            f1 -= 360.0f;
        }
        return f1;
    }

    public boolean m_183429_() {
        return true;
    }
}

