/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.goals;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.reaper.ancientnature.AncientNature;
import net.reaper.ancientnature.common.base.BaseAnimal;

public class GroundLayEggGoal
extends MoveToBlockGoal {
    private final BaseAnimal entity;
    private int layEggTimeout;
    private Block eggBlock;
    private BlockPos lastTargetPos = BlockPos.f_121853_;

    public GroundLayEggGoal(BaseAnimal pMob, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange, Block eggBlock) {
        super((PathfinderMob)pMob, pSpeedModifier, pSearchRange, pVerticalSearchRange);
        this.entity = pMob;
        this.eggBlock = eggBlock;
    }

    public void m_8056_() {
        super.m_8056_();
        this.layEggTimeout = 0;
    }

    protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
        BlockState state = pLevel.m_8055_(pPos);
        BlockState below = pLevel.m_8055_(pPos.m_7495_());
        boolean canPlaceEggHere = state.m_247087_() && !state.m_60713_(this.eggBlock);
        return state.m_60713_(Blocks.f_50016_) && below.m_280296_() && canPlaceEggHere;
    }

    public boolean m_8036_() {
        return this.entity.doesHaveEggs() && super.m_8036_();
    }

    public boolean m_8045_() {
        return this.entity.doesHaveEggs();
    }

    public void m_8037_() {
        super.m_8037_();
        AncientNature.LOGGER.info("Does have eggs: " + this.entity.doesHaveEggs());
        AncientNature.LOGGER.info("Block Target: " + this.f_25602_);
        if (this.m_25625_()) {
            BlockPos leftPos;
            BlockPos rightPos;
            Level level = this.entity.m_9236_();
            BlockPos entityPos = this.entity.m_20183_();
            BlockPos eggPos = null;
            BlockPos behindPos = entityPos.m_7918_(-this.entity.m_6350_().m_122429_(), 0, -this.entity.m_6350_().m_122431_());
            eggPos = this.canPlaceEggAt(level, behindPos) ? behindPos : (this.canPlaceEggAt(level, rightPos = entityPos.m_7918_(this.entity.m_6350_().m_122427_().m_122429_(), 0, this.entity.m_6350_().m_122427_().m_122431_())) ? rightPos : (this.canPlaceEggAt(level, leftPos = entityPos.m_7918_(this.entity.m_6350_().m_122428_().m_122429_(), 0, this.entity.m_6350_().m_122428_().m_122431_())) ? leftPos : this.f_25602_));
            AncientNature.LOGGER.info("HAS REACHED TARGET");
            if (!level.f_46443_) {
                level.m_5594_(null, eggPos, SoundEvents.f_12486_, SoundSource.BLOCKS, 0.3f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
                BlockState eggState = this.eggBlock.m_49966_();
                AncientNature.LOGGER.info("Can be placed: " + level.m_8055_(eggPos).m_247087_());
                if (level.m_8055_(eggPos).m_247087_()) {
                    AncientNature.LOGGER.info("Placing eggs at: " + eggPos);
                    level.m_7731_(eggPos, eggState, 3);
                    level.m_220407_(GameEvent.f_157797_, eggPos, GameEvent.Context.m_223719_((Entity)this.entity, (BlockState)eggState));
                    this.entity.setHasEggs(false);
                }
            }
        }
        ++this.layEggTimeout;
        if (this.layEggTimeout > 200) {
            boolean foundNewTarget = this.findDifferentNearestBlock();
            if (!foundNewTarget) {
                AncientNature.LOGGER.debug("No valid new target for placing eggs found, resetting search...");
            }
            this.layEggTimeout = 0;
        }
    }

    private boolean canPlaceEggAt(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_247087_() && level.m_8055_(pos.m_7495_()).m_280296_() && !level.m_8055_(pos).m_60713_(this.eggBlock);
    }

    private boolean findDifferentNearestBlock() {
        BlockPos oldTarget = this.f_25602_;
        if (super.m_25626_() && !this.f_25602_.equals((Object)oldTarget)) {
            this.lastTargetPos = oldTarget;
            return true;
        }
        return false;
    }
}

