/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.goals;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.phys.AABB;
import net.reaper.ancientnature.common.base.BaseAnimal;
import net.reaper.ancientnature.common.entity.DodoEntity;
import org.jetbrains.annotations.NotNull;

public class GroupHuntingGoal<T extends LivingEntity>
extends NearestAttackableTargetGoal<LivingEntity> {
    private final Mob mob;
    private int groupSize;
    private double groupRange;
    private int targetRange;

    public GroupHuntingGoal(Mob mob, Class<T> targetClass, boolean mustSee, int groupSize, double groupRange, int targetRange) {
        super(mob, targetClass, mustSee, GroupHuntingGoal.createPredicate(mob, groupSize, groupRange));
        this.mob = mob;
        this.groupSize = groupSize;
        this.groupRange = groupRange;
        this.targetRange = targetRange;
    }

    private static Predicate<LivingEntity> createPredicate(Mob mob, int groupSize, double groupRange) {
        return target -> {
            BaseAnimal animal;
            if (mob instanceof BaseAnimal && !(animal = (BaseAnimal)mob).isHungryEnoughToHunt()) {
                return false;
            }
            if (!(target instanceof Cow || target instanceof Sheep || target instanceof Chicken || target instanceof Rabbit || target instanceof DodoEntity)) {
                return false;
            }
            int nearbyGroupSize = mob.m_20193_().m_45976_(mob.getClass(), mob.m_20191_().m_82400_(groupRange)).size();
            if (nearbyGroupSize >= groupSize && (target instanceof Cow || target instanceof Sheep)) {
                return true;
            }
            if (target instanceof Chicken) {
                return true;
            }
            if (target instanceof Rabbit) {
                return true;
            }
            return target instanceof DodoEntity;
        };
    }

    @NotNull
    protected AABB m_7255_(double pTargetDistance) {
        return this.mob.m_20191_().m_82377_((double)this.targetRange, 4.0, (double)this.targetRange);
    }

    private int getNearbyGroupSize(double range) {
        List nearbyMobs = this.mob.m_20193_().m_45976_(this.mob.getClass(), this.mob.m_20191_().m_82400_(range));
        return nearbyMobs.size();
    }
}

