/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.goals;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.reaper.ancientnature.common.entity.HorseshoeCrabEntity;
import net.reaper.ancientnature.common.entity.WormEntity;
import net.reaper.ancientnature.core.registry.ANEntities;

public class SearchAndDigForWormGoal
extends MoveToBlockGoal {
    private final HorseshoeCrabEntity entity;
    private int diggingTime;
    private boolean isDigging;
    private int postDigWaitTime;

    public SearchAndDigForWormGoal(HorseshoeCrabEntity pMob, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange) {
        super((PathfinderMob)pMob, pSpeedModifier, pSearchRange, pVerticalSearchRange);
        this.entity = pMob;
        this.diggingTime = 0;
        this.isDigging = false;
        this.postDigWaitTime = 0;
    }

    public boolean m_8036_() {
        return this.entity.isHalfHungry() && super.m_8036_();
    }

    public boolean m_8045_() {
        return this.isDigging || this.postDigWaitTime > 0 || super.m_8045_();
    }

    protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
        BlockState state = pLevel.m_8055_(pPos);
        BlockState above = pLevel.m_8055_(pPos.m_7494_());
        return (state.m_60713_(Blocks.f_50493_) || state.m_60713_(Blocks.f_49994_) || state.m_60713_(Blocks.f_49992_) || state.m_60713_(Blocks.f_220864_)) && pLevel.m_45527_(pPos.m_7494_()) && above.m_60713_(Blocks.f_50016_);
    }

    public void m_8056_() {
        super.m_8056_();
        this.diggingTime = 0;
        this.isDigging = false;
        this.entity.setisDigging(false);
        this.postDigWaitTime = 0;
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.m_25625_()) {
            if (!this.isDigging && this.postDigWaitTime == 0) {
                this.isDigging = true;
                this.entity.setisDigging(true);
                this.diggingTime = 0;
                this.entity.m_9236_().m_5594_(null, this.f_25602_, SoundEvents.f_12406_, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            if (this.isDigging) {
                ++this.diggingTime;
                this.entity.m_20334_(0.0, 0.0, 0.0);
                if (this.entity.m_20183_().m_7495_().equals((Object)Blocks.f_220864_) && this.diggingTime % 5 == 0) {
                    ((ServerLevel)this.entity.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_220864_.m_49966_()), (double)this.f_25602_.m_123341_() + 0.5, (double)(this.f_25602_.m_123342_() + 1), (double)this.f_25602_.m_123343_() + 0.5, 5, 0.2, 0.2, 0.2, 0.01);
                }
                if (this.entity.m_20183_().m_7495_().equals((Object)Blocks.f_49992_) && this.diggingTime % 5 == 0) {
                    ((ServerLevel)this.entity.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49992_.m_49966_()), (double)this.f_25602_.m_123341_() + 0.5, (double)(this.f_25602_.m_123342_() + 1), (double)this.f_25602_.m_123343_() + 0.5, 5, 0.2, 0.2, 0.2, 0.01);
                }
                if (this.entity.m_20183_().m_7495_().equals((Object)Blocks.f_49994_) && this.diggingTime % 5 == 0) {
                    ((ServerLevel)this.entity.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49994_.m_49966_()), (double)this.f_25602_.m_123341_() + 0.5, (double)(this.f_25602_.m_123342_() + 1), (double)this.f_25602_.m_123343_() + 0.5, 5, 0.2, 0.2, 0.2, 0.01);
                }
                if (this.entity.m_20183_().m_7495_().equals((Object)Blocks.f_50493_) && this.diggingTime % 5 == 0) {
                    ((ServerLevel)this.entity.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49994_.m_49966_()), (double)this.f_25602_.m_123341_() + 0.5, (double)(this.f_25602_.m_123342_() + 1), (double)this.f_25602_.m_123343_() + 0.5, 5, 0.2, 0.2, 0.2, 0.01);
                }
                if (this.diggingTime > 100) {
                    Level level = this.entity.m_9236_();
                    if (!level.f_46443_) {
                        WormEntity worm = new WormEntity((EntityType<WormEntity>)((EntityType)ANEntities.WORM.get()), level);
                        worm.m_6034_((double)this.f_25602_.m_123341_() + 0.5, this.f_25602_.m_123342_() + 1, (double)this.f_25602_.m_123343_() + 0.5);
                        level.m_7967_((Entity)worm);
                        int currentHunger = this.entity.getTicksUntilHungry();
                        this.entity.setTicksUntilHungry(Math.min(4000 + currentHunger, 12000));
                    }
                    this.isDigging = false;
                    this.entity.setisDigging(false);
                    this.postDigWaitTime = 60;
                }
            }
            if (this.postDigWaitTime > 0) {
                --this.postDigWaitTime;
                if (this.postDigWaitTime == 0) {
                    this.m_8041_();
                }
            }
        }
    }

    public void m_8041_() {
        super.m_8041_();
        this.isDigging = false;
        this.entity.setisDigging(false);
        this.diggingTime = 0;
        this.postDigWaitTime = 0;
    }
}

