/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.goals.water;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.reaper.ancientnature.common.base.BaseWaterAnimal;

public class WaterAttackGoal
extends MeleeAttackGoal {
    private final BaseWaterAnimal animal;
    private final int attackDelay;
    private final int animationLength;
    private int ticksUntilNextAttack;
    private boolean shouldCountTillNextAttack = false;

    public WaterAttackGoal(BaseWaterAnimal pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen, int attackDelay, int attackAnimationLength) {
        super((PathfinderMob)pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.animal = pMob;
        this.attackDelay = attackDelay;
        this.animationLength = attackAnimationLength;
        this.ticksUntilNextAttack = attackAnimationLength - attackDelay;
    }

    protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
        if (this.isEnemyWithinAttackDistance(pEnemy, pDistToEnemySqr)) {
            this.shouldCountTillNextAttack = true;
            if (this.isTimeToStartAttackAnimation()) {
                this.animal.setAttacking(true);
            }
            if (this.m_25564_()) {
                this.f_25540_.m_21563_().m_24946_(pEnemy.m_20185_(), pEnemy.m_20188_(), pEnemy.m_20189_());
                this.performAttack(pEnemy);
            }
        } else {
            this.m_25563_();
            this.shouldCountTillNextAttack = false;
            this.animal.setAttacking(false);
            this.animal.attackAnimationTimeout = 0;
        }
    }

    private boolean isEnemyWithinAttackDistance(LivingEntity pEnemy, double pDistToEnemySqr) {
        return pDistToEnemySqr <= this.m_6639_(pEnemy);
    }

    protected void m_25563_() {
        this.ticksUntilNextAttack = this.m_183277_(this.animationLength);
    }

    protected boolean m_25564_() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean isTimeToStartAttackAnimation() {
        return this.ticksUntilNextAttack <= this.attackDelay;
    }

    protected int m_25565_() {
        return this.ticksUntilNextAttack;
    }

    protected void performAttack(LivingEntity pEnemy) {
        this.m_25563_();
        this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
        this.f_25540_.m_7327_((Entity)pEnemy);
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.shouldCountTillNextAttack) {
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        }
    }

    public boolean m_8036_() {
        return super.m_8036_();
    }

    public void m_8041_() {
        this.animal.setAttacking(false);
        super.m_8041_();
    }
}

