/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.goals.water;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.reaper.ancientnature.AncientNature;
import net.reaper.ancientnature.common.base.BaseAnimal;

public class WaterLayEggGoal
extends MoveToBlockGoal {
    private final BaseAnimal entity;
    private int layEggTimeout;
    private Block eggBlock;
    private BlockPos lastTargetPos = BlockPos.f_121853_;
    private final Predicate<BlockPos> canLayEggHerePredicate;

    public WaterLayEggGoal(BaseAnimal pMob, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange, Block eggBlock, Predicate<BlockPos> canLayEggHerePredicate) {
        super((PathfinderMob)pMob, pSpeedModifier, pSearchRange, pVerticalSearchRange);
        this.entity = pMob;
        this.eggBlock = eggBlock;
        this.canLayEggHerePredicate = canLayEggHerePredicate;
    }

    public WaterLayEggGoal(BaseAnimal pMob, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange, Block eggBlock) {
        this(pMob, pSpeedModifier, pSearchRange, pVerticalSearchRange, eggBlock, pPos -> true);
    }

    private boolean isSolidBlock(LevelReader pLevel, BlockPos pPos) {
        BlockState state = pLevel.m_8055_(pPos);
        return state.m_280296_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.layEggTimeout = 0;
    }

    protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
        BlockState state = pLevel.m_8055_(pPos);
        BlockState below = pLevel.m_8055_(pPos.m_7495_());
        boolean hasSolidNeighbor = this.isSolidBlock(pLevel, pPos.m_7495_()) || this.isSolidBlock(pLevel, pPos.m_7494_()) || this.isSolidBlock(pLevel, pPos.m_121945_(Direction.NORTH)) || this.isSolidBlock(pLevel, pPos.m_121945_(Direction.SOUTH)) || this.isSolidBlock(pLevel, pPos.m_121945_(Direction.EAST)) || this.isSolidBlock(pLevel, pPos.m_121945_(Direction.WEST));
        boolean canPlaceEggHere = state.m_247087_() && !state.m_60713_(this.eggBlock);
        return this.canLayEggHerePredicate.test(pPos) && state.m_60713_(Blocks.f_49990_) && (Integer)state.m_61143_((Property)BlockStateProperties.f_61422_) == 0 && below.m_280296_() && canPlaceEggHere;
    }

    public boolean m_8036_() {
        return this.entity.doesHaveEggs() && super.m_8036_();
    }

    public boolean m_8045_() {
        return this.entity.doesHaveEggs();
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.m_25625_() && this.entity.m_20069_()) {
            Level level = this.entity.m_9236_();
            BlockPos targetPos = this.f_25602_;
            if (!level.f_46443_) {
                level.m_5594_(null, targetPos, SoundEvents.f_12486_, SoundSource.BLOCKS, 0.3f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
                BlockState eggState = this.eggBlock.m_49966_();
                if (level.m_8055_(targetPos).m_247087_()) {
                    level.m_7731_(targetPos, (BlockState)eggState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN), 3);
                    level.m_220407_(GameEvent.f_157797_, targetPos, GameEvent.Context.m_223719_((Entity)this.entity, (BlockState)eggState));
                    this.entity.setHasEggs(false);
                }
            }
        }
        ++this.layEggTimeout;
        if (this.layEggTimeout > 200) {
            boolean foundNewTarget = this.findDifferentNearestBlock();
            if (!foundNewTarget) {
                AncientNature.LOGGER.debug("No valid new target for placing eggs found, resetting search...");
            }
            this.layEggTimeout = 0;
        }
    }

    private boolean findDifferentNearestBlock() {
        BlockPos oldTarget = this.f_25602_;
        if (super.m_25626_() && !this.f_25602_.equals((Object)oldTarget)) {
            this.lastTargetPos = oldTarget;
            return true;
        }
        return false;
    }
}

