/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.reaper.ancientnature.core.registry.ANTags;
import org.jetbrains.annotations.NotNull;

public class GeologistHammerItem
extends DiggerItem {
    public GeologistHammerItem(float pAttackDamageModifier, float pAttackSpeedModifier, Tier pTier, TagKey<Block> pBlocks, Item.Properties pProperties) {
        super(pAttackDamageModifier, pAttackSpeedModifier, pTier, pBlocks, pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack;
        boolean isEfficient = this.isEfficient(itemStack = player.m_21120_(hand));
        this.setEfficient(itemStack, !isEfficient);
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }

    public boolean isEfficient(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41783_();
        return compoundTag != null && compoundTag.m_128471_("Efficient");
    }

    public void setEfficient(ItemStack stack, boolean efficient) {
        stack.m_41784_().m_128379_("Efficient", efficient);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        String state = this.isEfficient(stack) ? "Efficient" : "Hammer";
        tooltipComponents.add((Component)Component.m_237113_((String)("Mode: " + state)));
    }

    public float m_8102_(@NotNull ItemStack stack, @NotNull BlockState block) {
        if (this.isEfficient(stack)) {
            return super.m_8102_(stack, block) / 4.0f;
        }
        return super.m_8102_(stack, block);
    }

    public boolean m_6813_(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity player) {
        if (this.isEfficient(stack)) {
            MinecraftServer server;
            if (state.m_204336_(ANTags.Blocks.FOSSILS) && !level.f_46443_ && (server = level.m_7654_()) != null) {
                LootParams.Builder lootParamsBuilder = new LootParams.Builder(server.m_129880_(level.m_46472_())).m_287286_(LootContextParams.f_81460_, (Object)pos.m_252807_()).m_287286_(LootContextParams.f_81461_, (Object)state).m_287289_(LootContextParams.f_81463_, (Object)player.m_21205_()).m_287289_(LootContextParams.f_81455_, (Object)player);
                List drops = state.m_287290_(lootParamsBuilder);
                int multiplier = level.m_213780_().m_188503_(2) + 1;
                for (int i = 0; i < multiplier; ++i) {
                    for (ItemStack drop : drops) {
                        if (drop.m_41619_()) continue;
                        Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)drop.m_41777_());
                    }
                }
            }
            return super.m_6813_(stack, level, state, pos, player);
        }
        BlockPos abovePos = pos.m_7494_();
        BlockState aboveState = level.m_8055_(abovePos);
        if (aboveState.m_60800_((BlockGetter)level, abovePos) <= state.m_60800_((BlockGetter)level, pos) && aboveState.canHarvestBlock((BlockGetter)level, abovePos, (Player)player)) {
            level.m_46961_(abovePos, true);
        }
        return super.m_6813_(stack, level, state, pos, player);
    }
}

