/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.item;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class LepidodendronScaleArmorItem
extends ArmorItem {
    private static final Random RANDOM = new Random();

    public LepidodendronScaleArmorItem(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        super.m_6883_(stack, level, entity, slot, isSelected);
        if (entity instanceof LivingEntity) {
            Player player;
            LivingEntity livingEntity = (LivingEntity)entity;
            if ((!(entity instanceof Player) || !(player = (Player)entity).m_7500_()) && this.isEquipped(livingEntity) && this.isInFireSource(livingEntity)) {
                this.breakArmorPiece(livingEntity, stack);
                level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11937_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    private boolean isEquipped(LivingEntity entity) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack equippedItem;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (equippedItem = entity.m_6844_(slot)).m_41720_() != this) continue;
            return true;
        }
        return false;
    }

    private boolean isInFireSource(LivingEntity entity) {
        BlockPos pos = entity.m_20183_();
        if (entity.m_9236_().m_8055_(pos).m_60734_() instanceof BaseFireBlock || entity.m_9236_().m_8055_(pos).m_60734_() instanceof MagmaBlock || entity.m_9236_().m_8055_(pos).m_60734_() == Blocks.f_49991_) {
            return true;
        }
        return entity.m_6060_();
    }

    private void breakArmorPiece(LivingEntity entity, ItemStack stack) {
        Player player;
        if (!(entity instanceof Player) || !(player = (Player)entity).m_7500_()) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack equippedArmor;
                if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (equippedArmor = entity.m_6844_(slot)) != stack) continue;
                entity.m_8061_(slot, ItemStack.f_41583_);
                entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 0.8f, 0.8f + entity.m_9236_().f_46441_.m_188501_() * 0.4f);
                return;
            }
        }
    }

    @Mod.EventBusSubscriber(modid="ancientnature")
    public static class ArmorEvents {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            LivingEntity livingAttacker;
            ItemStack heldItem;
            Entity attacker;
            Entity attacker2;
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player && ArmorEvents.isWearingLepidodendronArmor((LivingEntity)(player = (Player)livingEntity)) && RANDOM.nextFloat() <= 0.5f && (attacker2 = event.getSource().m_7639_()) instanceof LivingEntity) {
                LivingEntity livingAttacker2 = (LivingEntity)attacker2;
                livingAttacker2.m_6469_(player.m_269291_().m_269374_((Entity)player), 2.0f);
            }
            if (event.getEntity() instanceof LivingEntity && ArmorEvents.isWearingLepidodendronArmor(event.getEntity()) && (attacker = event.getSource().m_7639_()) instanceof LivingEntity && (heldItem = (livingAttacker = (LivingEntity)attacker).m_21205_()).m_41720_() instanceof AxeItem) {
                ArmorEvents.breakAllArmorPieces(event.getEntity());
                event.getEntity().m_9236_().m_5594_(null, event.getEntity().m_20183_(), SoundEvents.f_12630_, SoundSource.PLAYERS, 1.0f, 0.8f);
            }
        }

        @SubscribeEvent
        public static void onLivingAttack(LivingAttackEvent event) {
            DamageSource source;
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player && ArmorEvents.isWearingLepidodendronArmor((LivingEntity)(player = (Player)livingEntity)) && RANDOM.nextFloat() <= 0.35f && ((source = event.getSource()).m_7640_() instanceof Projectile || source.m_7639_() != null)) {
                event.setCanceled(true);
                player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 0.8f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
                Entity entity = source.m_7640_();
                if (entity instanceof Projectile) {
                    Projectile projectile = (Projectile)entity;
                    Vec3 motion = projectile.m_20184_().m_82490_(-0.3);
                    projectile.m_20256_(motion);
                }
            }
        }

        private static boolean isWearingLepidodendronArmor(LivingEntity entity) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack;
                if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || !((stack = entity.m_6844_(slot)).m_41720_() instanceof LepidodendronScaleArmorItem)) continue;
                return true;
            }
            return false;
        }

        private static void breakAllArmorPieces(LivingEntity entity) {
            Player player;
            if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
                return;
            }
            boolean armorBroken = false;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack;
                if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || !((stack = entity.m_6844_(slot)).m_41720_() instanceof LepidodendronScaleArmorItem)) continue;
                entity.m_8061_(slot, ItemStack.f_41583_);
                armorBroken = true;
            }
            if (armorBroken) {
                entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 0.8f);
            }
        }
    }
}

