/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.menu;

import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.reaper.ancientnature.common.menu.UtilMenu;

public abstract class BaseTileEntityMenu<T extends BlockEntity>
extends UtilMenu {
    protected final T tileEntity;

    public BaseTileEntityMenu(MenuType<?> type, int id, Inventory inv, T tileEntity) {
        super(type, id, inv);
        this.tileEntity = tileEntity;
        this.init();
    }

    public BaseTileEntityMenu(MenuType<?> type, int id, Inventory inv, FriendlyByteBuf buffer) {
        this(type, id, inv, BaseTileEntityMenu.getClientTileEntity(inv, buffer));
    }

    public abstract void init();

    @OnlyIn(value=Dist.CLIENT)
    protected static <X extends BlockEntity> X getClientTileEntity(Inventory inventory, FriendlyByteBuf buffer) {
        Objects.requireNonNull(inventory, "the inventory must not be null");
        Objects.requireNonNull(buffer, "the buffer must not be null");
        BlockEntity tileEntity = inventory.f_35978_.m_9236_().m_7702_(buffer.m_130135_());
        return (X)tileEntity;
    }

    public boolean m_6875_(Player pPlayer) {
        return ((Container)this.tileEntity).m_6542_(pPlayer);
    }

    public T getTileEntity() {
        return this.tileEntity;
    }

    public static class FuelSlot
    extends Slot {
        protected final RecipeType<?> recipeType;

        public FuelSlot(Container inventoryIn, RecipeType<?> recipeType, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
            this.recipeType = recipeType;
        }

        public FuelSlot(Container pContainer, int pSlot, int pX, int pY) {
            this(pContainer, null, pSlot, pX, pY);
        }

        public boolean m_5857_(ItemStack stack) {
            return ForgeHooks.getBurnTime((ItemStack)stack, null) > 0;
        }
    }
}

