/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.menu;

import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class UtilMenu
extends AbstractContainerMenu {
    protected Inventory playerInventory;

    public static String makeTranslationKey(String name) {
        return "menu.ancientnature." + name;
    }

    public UtilMenu(MenuType<?> type, int id, Inventory inv) {
        super(type, id);
        this.playerInventory = inv;
    }

    protected int addHorizontalSlots(Container handler, int Index, int x, int y, int amount, int distanceBetweenSlots) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_(new Slot(handler, Index, x, y));
            ++Index;
            x += distanceBetweenSlots;
        }
        return Index;
    }

    protected int addSlotField(Container handler, int StartIndex, int x, int y, int horizontalAmount, int horizontalDistance, int verticalAmount, int VerticalDistance) {
        for (int i = 0; i < verticalAmount; ++i) {
            StartIndex = this.addHorizontalSlots(handler, StartIndex, x, y, horizontalAmount, horizontalDistance);
            y += VerticalDistance;
        }
        return StartIndex;
    }

    protected <T extends Container> int addHorizontalSlots(T handler, int Index, int x, int y, int amount, int distanceBetweenSlots, SlotFunction<T> provider) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_(provider.makeSlot(handler, Index, x, y));
            ++Index;
            x += distanceBetweenSlots;
        }
        return Index;
    }

    protected <T extends Container> int addSlotField(T handler, int StartIndex, int x, int y, int horizontalAmount, int horizontalDistance, int verticalAmount, int VerticalDistance, SlotFunction<T> provider) {
        for (int i = 0; i < verticalAmount; ++i) {
            StartIndex = this.addHorizontalSlots(handler, StartIndex, x, y, horizontalAmount, horizontalDistance, provider);
            y += VerticalDistance;
        }
        return StartIndex;
    }

    protected void addPlayerInventory(int x, int y) {
        this.addSlotField((Container)this.playerInventory, 9, x, y, 9, 18, 3, 18);
        this.addHorizontalSlots((Container)this.playerInventory, 0, x, y += 58, 9, 18);
    }

    protected int getPlayerBeginSlots() {
        for (int i = 0; i < this.f_38839_.size(); ++i) {
            if (!(((Slot)this.f_38839_.get((int)i)).f_40218_ instanceof Inventory)) continue;
            return i;
        }
        return -1;
    }

    public static interface SlotFunction<T extends Container> {
        public Slot makeSlot(T var1, int var2, int var3, int var4);
    }

    protected static class SingletonSlot
    extends Slot {
        public SingletonSlot(Container pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
        }

        public int m_6641_() {
            return 1;
        }
    }

    protected static class FilterSlot
    extends Slot {
        protected final Predicate<ItemStack> validation;

        public FilterSlot(Container pContainer, int pSlot, int pX, int pY, Predicate<ItemStack> validation) {
            super(pContainer, pSlot, pX, pY);
            this.validation = validation;
        }

        public boolean m_5857_(ItemStack pStack) {
            return this.validation.test(pStack);
        }
    }

    protected static class LockedSlot
    extends Slot {
        public LockedSlot(Container inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack pStack) {
            return false;
        }
    }
}

