/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Random;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.reaper.ancientnature.core.registry.ANRecipes;
import org.jetbrains.annotations.Nullable;

public class BrushingRecipe
implements Recipe<Container> {
    public static final Serializer SERIALIZER = new Serializer();
    protected final ResourceLocation id;
    protected final Ingredient input;
    protected final Ingredient brush;
    protected final ItemStack output;
    protected final float probabilityForOutput;
    protected Random cachedRandom;

    public BrushingRecipe(ResourceLocation id, Ingredient input, Ingredient brush, ItemStack output, float probabilityForOutput) {
        this.id = id;
        this.input = input;
        this.brush = brush;
        this.output = output;
        this.probabilityForOutput = probabilityForOutput;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        if (pContainer.m_6643_() == 2) {
            if (this.brush.test(pContainer.m_8020_(0)) && pContainer.m_8020_(0).m_41763_() && this.input.test(pContainer.m_8020_(1))) {
                return true;
            }
            if (this.input.test(pContainer.m_8020_(0)) && this.brush.test(pContainer.m_8020_(1)) && pContainer.m_8020_(1).m_41763_()) {
                return true;
            }
        }
        return false;
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        if (this.cachedRandom == null) {
            this.cachedRandom = new Random();
        }
        return this.cachedRandom.nextFloat() <= this.probabilityForOutput ? this.output.m_41777_() : ItemStack.f_41583_;
    }

    public Ingredient getBrush() {
        return this.brush;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ANRecipes.BRUSHING_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<BrushingRecipe> {
        public BrushingRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            float probability = Mth.m_14036_((float)GsonHelper.m_13820_((JsonObject)pSerializedRecipe, (String)"probability", (float)0.2f), (float)0.0f, (float)1.0f);
            Ingredient input = Ingredient.m_43917_((JsonElement)pSerializedRecipe.get("input"));
            Ingredient brush = Ingredient.m_43917_((JsonElement)pSerializedRecipe.get("brush"));
            ItemStack output = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"), (boolean)true);
            return new BrushingRecipe(pRecipeId, input, brush, output, probability);
        }

        @Nullable
        public BrushingRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            float probability = pBuffer.readFloat();
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient brush = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ItemStack output = pBuffer.m_130267_();
            return new BrushingRecipe(pRecipeId, input, brush, output, probability);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, BrushingRecipe pRecipe) {
            pBuffer.writeFloat(pRecipe.probabilityForOutput);
            pRecipe.input.m_43923_(pBuffer);
            pRecipe.brush.m_43923_(pBuffer);
            pBuffer.m_130055_(pRecipe.output);
        }
    }
}

