/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.reaper.ancientnature.common.block.blockentity.RevivalStandBlockEntity;
import net.reaper.ancientnature.common.util.IngredientCount;
import net.reaper.ancientnature.core.registry.ANRecipes;
import org.jetbrains.annotations.Nullable;

public class RevivalStandRecipe
implements Recipe<RevivalStandBlockEntity> {
    public static final Serializer SERIALIZER = new Serializer();
    protected final IngredientCount fossil;
    protected final IngredientCount amber;
    protected final int amberInfusionTime;
    protected final int fossilInfusionTime;
    protected final Ingredient baseRoe;
    protected final ItemStack eggs;
    protected final ResourceLocation id;

    public RevivalStandRecipe(IngredientCount fossil, IngredientCount amber, int amberInfusionTime, int fossilInfusionTime, Ingredient baseRoe, ItemStack eggs, ResourceLocation id) {
        this.fossil = fossil;
        this.amber = amber;
        this.amberInfusionTime = amberInfusionTime;
        this.fossilInfusionTime = fossilInfusionTime;
        this.baseRoe = baseRoe;
        this.eggs = eggs;
        this.id = id;
    }

    public boolean matches(RevivalStandBlockEntity pContainer, Level pLevel) {
        boolean amberMatch = this.amber.test(pContainer.m_8020_(1));
        boolean fossilMatch = this.fossil.test(pContainer.m_8020_(2));
        boolean baseRoeMatch = this.baseRoe.test(pContainer.m_8020_(3));
        int eggCount = pContainer.m_8020_(3).m_41613_();
        int requiredEggCount = 1;
        if (amberMatch && fossilMatch) {
            return baseRoeMatch && eggCount >= requiredEggCount;
        }
        return false;
    }

    public ItemStack assemble(RevivalStandBlockEntity pContainer, RegistryAccess pRegistryAccess) {
        this.amber.shrink(pContainer.m_8020_(1));
        this.fossil.shrink(pContainer.m_8020_(2));
        return this.eggs;
    }

    public Ingredient getBaseRoe() {
        return this.baseRoe;
    }

    public int getAmberInfusionTime() {
        return this.amberInfusionTime;
    }

    public int getFossilInfusionTime() {
        return this.fossilInfusionTime;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.eggs;
    }

    public IngredientCount getAmber() {
        return this.amber;
    }

    public IngredientCount getFossil() {
        return this.fossil;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ANRecipes.REVIVAL_STAND_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<RevivalStandRecipe> {
        public RevivalStandRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            IngredientCount fossil = IngredientCount.fromJson(GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"fossil"));
            IngredientCount amber = IngredientCount.fromJson(GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"amber"));
            Ingredient baseRoe = Ingredient.f_43901_;
            if (pSerializedRecipe.has("base_roe")) {
                baseRoe = Ingredient.m_43917_((JsonElement)pSerializedRecipe.get("base_roe"));
            }
            int amberInfusionTime = GsonHelper.m_13824_((JsonObject)pSerializedRecipe, (String)"amberInfusionTime", (int)200);
            int fossilInfusionTime = GsonHelper.m_13824_((JsonObject)pSerializedRecipe, (String)"fossilInfusionTime", (int)200);
            ItemStack eggs = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"egg"), (boolean)true);
            return new RevivalStandRecipe(fossil, amber, amberInfusionTime, fossilInfusionTime, baseRoe, eggs, pRecipeId);
        }

        @Nullable
        public RevivalStandRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            IngredientCount amber = IngredientCount.fromBuffer(pBuffer);
            IngredientCount fossil = IngredientCount.fromBuffer(pBuffer);
            Ingredient baseRoe = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ItemStack eggs = pBuffer.m_130267_();
            int amberInfusion = pBuffer.readInt();
            int fossilInfusion = pBuffer.readInt();
            return new RevivalStandRecipe(fossil, amber, amberInfusion, fossilInfusion, baseRoe, eggs, pRecipeId);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, RevivalStandRecipe pRecipe) {
            pRecipe.amber.toNetwork(pBuffer);
            pRecipe.fossil.toNetwork(pBuffer);
            pRecipe.baseRoe.m_43923_(pBuffer);
            pBuffer.m_130055_(pRecipe.eggs);
            pBuffer.writeInt(pRecipe.amberInfusionTime);
            pBuffer.writeInt(pRecipe.fossilInfusionTime);
        }
    }
}

