/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;

public class AStar {
    private int[][] grid;
    private int width;
    private int height;

    public AStar(int[][] grid) {
        this.grid = grid;
        this.width = grid.length;
        this.height = grid[0].length;
    }

    public List<Node> findPath(int startX, int startY, int targetX, int targetY) {
        PriorityQueue<Node> openList = new PriorityQueue<Node>();
        HashSet<Node> closedList = new HashSet<Node>();
        Node startNode = new Node(startX, startY);
        Node targetNode = new Node(targetX, targetY);
        openList.add(startNode);
        while (!openList.isEmpty()) {
            Node currentNode = (Node)openList.poll();
            closedList.add(currentNode);
            if (currentNode.equals(targetNode)) {
                return this.reconstructPath(currentNode);
            }
            for (Node neighbor : this.getNeighbors(currentNode)) {
                double tentativeGCost;
                if (closedList.contains(neighbor) || !((tentativeGCost = currentNode.gCost + this.getDistance(currentNode, neighbor)) < neighbor.gCost) && openList.contains(neighbor)) continue;
                neighbor.gCost = tentativeGCost;
                neighbor.hCost = this.getDistance(neighbor, targetNode);
                neighbor.fCost = neighbor.gCost + neighbor.hCost;
                neighbor.parent = currentNode;
                if (openList.contains(neighbor)) continue;
                openList.add(neighbor);
            }
        }
        return Collections.emptyList();
    }

    private List<Node> getNeighbors(Node node) {
        ArrayList<Node> neighbors = new ArrayList<Node>();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                int newY;
                int newX;
                if (dx == 0 && dy == 0 || !this.isValid(newX = node.x + dx, newY = node.y + dy)) continue;
                neighbors.add(new Node(newX, newY));
            }
        }
        return neighbors;
    }

    private boolean isValid(int x, int y) {
        return x >= 0 && y >= 0 && x < this.width && y < this.height && this.grid[x][y] == 0;
    }

    private double getDistance(Node a, Node b) {
        int dx = Math.abs(a.x - b.x);
        int dy = Math.abs(a.y - b.y);
        return Math.sqrt(dx * dx + dy * dy);
    }

    private List<Node> reconstructPath(Node node) {
        ArrayList<Node> path = new ArrayList<Node>();
        while (node != null) {
            path.add(node);
            node = node.parent;
        }
        Collections.reverse(path);
        return path;
    }

    public static class Node
    implements Comparable<Node> {
        public int x;
        public int y;
        double gCost;
        double hCost;
        double fCost;
        Node parent;

        public Node(int x, int y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public int compareTo(Node other) {
            return Double.compare(this.fCost, other.fCost);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Node node = (Node)obj;
            return this.x == node.x && this.y == node.y;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y);
        }
    }
}

