/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class AnimalDiet {
    private final List<Item> items;
    private final List<Block> blocks;

    private AnimalDiet(Builder builder) {
        this.items = builder.items;
        this.blocks = builder.blocks;
    }

    public boolean test(ItemStack item) {
        return this.items.contains(item.m_41720_());
    }

    public List<Item> getItems() {
        return this.items;
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public static class Builder {
        private final List<Item> items = new ArrayList<Item>();
        private final List<Block> blocks = new ArrayList<Block>();

        public Builder addItems(Item ... items) {
            Collections.addAll(this.items, items);
            return this;
        }

        public Builder addItems(List<Item> items) {
            Collections.addAll(this.items, items.toArray(new Item[0]));
            return this;
        }

        public Builder addBlocks(Block ... blocks) {
            Collections.addAll(this.blocks, blocks);
            return this;
        }

        public AnimalDiet build() {
            return new AnimalDiet(this);
        }
    }
}

