/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.util;

import java.lang.reflect.Method;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class BoidUtil {
    public static final Method GET_ENTITY = ObfuscationReflectionHelper.findMethod(Level.class, (String)"m_142646_", (Class[])new Class[0]);

    public static BlockPos getGroundPos(BlockGetter pLevel, double pX, double startY, double pZ) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(pX, startY, pZ);
        do {
            blockpos$mutable.m_122173_(Direction.DOWN);
        } while ((pLevel.m_8055_((BlockPos)blockpos$mutable).m_60795_() || pLevel.m_8055_((BlockPos)blockpos$mutable).m_278721_() || !pLevel.m_8055_((BlockPos)blockpos$mutable).m_60838_(pLevel, (BlockPos)blockpos$mutable)) && blockpos$mutable.m_123342_() > pLevel.m_141937_());
        BlockPos blockpos = blockpos$mutable.m_7495_();
        return blockpos;
    }

    public static void fishPanic(PathfinderMob mob, Vec3 sourcePos, double speed) {
        Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)mob, (int)16, (int)7, (Vec3)sourcePos);
        if (vec3 != null) {
            mob.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, speed);
            if (mob instanceof AbstractFish) {
                AbstractFish fish = (AbstractFish)mob;
                fish.m_7618_(EntityAnchorArgument.Anchor.EYES, vec3);
                fish.m_20256_(BoidUtil.fromToVector(fish.m_20182_(), vec3, 0.35f));
            }
        }
    }

    public static Vec3 fromToVector(Vec3 from, Vec3 to, float scale) {
        Vec3 motion = to.m_82546_(from).m_82541_();
        return motion.m_82490_((double)scale);
    }

    public static Vec3 fromToVector(Vec3 from, Vec3 to) {
        Vec3 motion = to.m_82546_(from).m_82541_();
        return motion;
    }

    public static void fishFlopping(LivingEntity entity) {
        BoidUtil.fishFlopping(entity, SoundEvents.f_11760_, 1.0f, 0.5f);
    }

    public static void fishFlopping(LivingEntity entity, SoundEvent flopSound, float volume, float yMotion) {
        if (!entity.m_20069_() && entity.m_20096_() && entity.f_19863_) {
            entity.m_20256_(entity.m_20184_().m_82520_((double)((entity.m_217043_().m_188501_() * 2.0f - 1.0f) * 0.05f), (double)yMotion, (double)((entity.m_217043_().m_188501_() * 2.0f - 1.0f) * 0.05f)));
            entity.m_6853_(false);
            entity.f_19812_ = true;
            entity.m_5496_(flopSound, volume, entity.m_6100_());
        }
    }

    public static Entity getEntityByUUID(Level level, UUID uuid) {
        try {
            LevelEntityGetter entities = (LevelEntityGetter)GET_ENTITY.invoke((Object)level, new Object[0]);
            return (Entity)entities.m_142694_(uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void getClientLevel(Consumer<Level> consumer) {
        ((Optional)LogicalSidedProvider.CLIENTWORLD.get(LogicalSide.CLIENT)).filter(ClientLevel.class::isInstance).ifPresent(level -> consumer.accept((Level)level));
    }

    public static Vec3 getRandomPosition(Entity entity, int range) {
        Vec3 vec3 = entity.m_20182_().m_82520_((double)Mth.m_216287_((RandomSource)entity.m_9236_().f_46441_, (int)(-range), (int)range), (double)Mth.m_216287_((RandomSource)entity.m_9236_().f_46441_, (int)(-range), (int)range), (double)Mth.m_216287_((RandomSource)entity.m_9236_().f_46441_, (int)(-range), (int)range));
        return vec3;
    }

    public static Vec3 getSpreadPosition(Entity entity, Vec3 range) {
        double x = entity.m_20185_() + (entity.m_9236_().f_46441_.m_188500_() - entity.m_9236_().f_46441_.m_188500_()) * range.f_82479_ + 0.5;
        double y = entity.m_20186_() + (entity.m_9236_().f_46441_.m_188500_() - entity.m_9236_().f_46441_.m_188500_()) * range.f_82480_ + 0.5;
        double z = entity.m_20189_() + (entity.m_9236_().f_46441_.m_188500_() - entity.m_9236_().f_46441_.m_188500_()) * range.f_82481_ + 0.5;
        return new Vec3(x, y, z);
    }

    public static Vec3 getSpreadPosition(Entity entity, double range) {
        double x = entity.m_20185_() + (entity.m_9236_().f_46441_.m_188500_() - entity.m_9236_().f_46441_.m_188500_()) * range + 0.5;
        double y = entity.m_20186_() + (entity.m_9236_().f_46441_.m_188500_() - entity.m_9236_().f_46441_.m_188500_()) * range + 0.5;
        double z = entity.m_20189_() + (entity.m_9236_().f_46441_.m_188500_() - entity.m_9236_().f_46441_.m_188500_()) * range + 0.5;
        return new Vec3(x, y, z);
    }

    public static Vec3 getLookPos(Vec2 rotation, Vec3 position, double left, double up, double forwards) {
        Vec2 vec2 = rotation;
        Vec3 vec3 = position;
        float f = Mth.m_14089_((float)((vec2.f_82471_ + 90.0f) * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)((vec2.f_82471_ + 90.0f) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(-vec2.f_82470_ * ((float)Math.PI / 180)));
        float f3 = Mth.m_14031_((float)(-vec2.f_82470_ * ((float)Math.PI / 180)));
        float f4 = Mth.m_14089_((float)((-vec2.f_82470_ + 90.0f) * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)((-vec2.f_82470_ + 90.0f) * ((float)Math.PI / 180)));
        Vec3 vec31 = new Vec3((double)(f * f2), (double)f3, (double)(f1 * f2));
        Vec3 vec32 = new Vec3((double)(f * f4), (double)f5, (double)(f1 * f4));
        Vec3 vec33 = vec31.m_82537_(vec32).m_82490_(-1.0);
        double d0 = vec31.f_82479_ * forwards + vec32.f_82479_ * up + vec33.f_82479_ * left;
        double d1 = vec31.f_82480_ * forwards + vec32.f_82480_ * up + vec33.f_82480_ * left;
        double d2 = vec31.f_82481_ * forwards + vec32.f_82481_ * up + vec33.f_82481_ * left;
        return new Vec3(vec3.f_82479_ + d0, vec3.f_82480_ + d1, vec3.f_82481_ + d2);
    }

    public static float rotlerp(float p_24992_, float p_24993_, float p_24994_) {
        float f1;
        float f = Mth.m_14177_((float)(p_24993_ - p_24992_));
        if (f > p_24994_) {
            f = p_24994_;
        }
        if (f < -p_24994_) {
            f = -p_24994_;
        }
        if ((f1 = p_24992_ + f) < 0.0f) {
            f1 += 360.0f;
        } else if (f1 > 360.0f) {
            f1 -= 360.0f;
        }
        return f1;
    }
}

