/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.util;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.reaper.ancientnature.common.entity.ParanogmiusEntity;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class EntityUtils {
    @Nullable
    public static <T extends Entity> List<T> getEntitiesAroundSelf(Class<T> pEntityClass, @Nullable Entity pSelf, float pHorizontalRadius, float pVerticalRadius, boolean pMustSee) {
        if (pSelf == null) {
            return null;
        }
        AABB aabb = AABB.m_165882_((Vec3)pSelf.m_20182_(), (double)pHorizontalRadius, (double)pVerticalRadius, (double)pHorizontalRadius);
        List entityList = pSelf.m_9236_().m_6443_(pEntityClass, aabb, EntitySelector.f_20402_);
        if (!entityList.isEmpty()) {
            if (pMustSee) {
                for (Entity entity : entityList) {
                    LivingEntity living;
                    if (!(pSelf instanceof LivingEntity) || !(living = (LivingEntity)pSelf).m_142582_(entity)) continue;
                    return entityList;
                }
            }
            return entityList;
        }
        return null;
    }

    public static boolean isEntityStepping(LivingEntity pEntity, float pAnimationSpeedFactor, float pScale) {
        float stepOffset = (float)Math.tan(pEntity.f_267362_.m_267756_() * pAnimationSpeedFactor - 0.2f);
        return stepOffset * stepOffset < pScale * pScale;
    }

    public static boolean isEntityMoving(@Nullable Entity pEntity, float pMinChange) {
        if (pEntity == null) {
            return false;
        }
        Vec3 delta = pEntity.m_20184_();
        return !(delta.m_82553_() > (double)(-pMinChange)) || !(delta.m_82553_() < (double)pMinChange);
    }

    public static void attackByRider(@Nullable LivingEntity pEntity, float pAttackDistance, float pAttackDamage) {
        LivingEntity passenger;
        if (pEntity != null && (passenger = pEntity.m_6688_()) != null) {
            Entity target;
            Vec3 startPos = passenger.m_146892_();
            Vec3 endPos = startPos.m_82549_(passenger.m_20252_(2.3f).m_82490_((double)(pAttackDistance * pAttackDistance)));
            AABB aabb = new AABB(startPos, endPos).m_82400_(3.0);
            EntityHitResult hitResult = ProjectileUtil.m_150175_((Level)passenger.m_9236_(), (Entity)passenger, (Vec3)startPos, (Vec3)endPos, (AABB)aabb, entity -> {
                LivingEntity living;
                return entity instanceof LivingEntity && pEntity.m_6779_(living = (LivingEntity)entity);
            }, (float)1.0f);
            if (hitResult != null && (target = hitResult.m_82443_()) != pEntity) {
                pEntity.m_21335_(target);
                target.m_6469_(pEntity.m_269291_().m_269333_(pEntity), pAttackDamage);
            }
        }
    }

    @Contract(value="null->false")
    public static boolean isPlayerPassengerOf(@Nullable LivingEntity pEntity) {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        return localPlayer != null && pEntity != null && localPlayer.m_20202_() != null && localPlayer.m_20202_() == pEntity;
    }

    public static void smoothVehicleYawToRider(@NotNull Player pRider, @NotNull LivingEntity pVehicle, float pSmoothFactor, float pRotationSpeed) {
        float interpolatedRotation;
        pVehicle.f_19859_ = interpolatedRotation = Mth.m_14189_((float)pSmoothFactor, (float)pVehicle.f_19859_, (float)pRider.m_6080_());
        pVehicle.f_20883_ = interpolatedRotation;
        pVehicle.f_20885_ = interpolatedRotation;
        pVehicle.m_146922_(Mth.m_14189_((float)pRotationSpeed, (float)pVehicle.m_146908_(), (float)pRider.m_146908_()));
    }

    public static void removeRider(@NotNull LivingEntity pVehicle, @Nullable Player pRider) {
        if (pRider == null) {
            return;
        }
        Vec3 vec3 = pRider.m_213877_() ? pRider.m_20182_() : (!pVehicle.m_213877_() && !pVehicle.m_9236_().m_8055_(pVehicle.m_20183_()).m_204336_(BlockTags.f_13075_) ? pVehicle.m_7688_(pVehicle) : new Vec3(pRider.m_20185_(), Math.max(pRider.m_20186_(), pVehicle.m_20186_()), pRider.m_20189_()));
        pRider.m_142098_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    public static boolean canSprintByPlayer(@NotNull LivingEntity pEntity) {
        return Minecraft.m_91087_().f_91066_.f_92091_.m_90857_() && EntityUtils.isPlayerPassengerOf(pEntity);
    }

    public static boolean canAttackByPlayer(@NotNull LivingEntity pEntity) {
        return Minecraft.m_91087_().f_91066_.f_92096_.m_90857_() && EntityUtils.isPlayerPassengerOf(pEntity);
    }

    public static boolean canRoarByPlayer(@NotNull LivingEntity pEntity) {
        return Minecraft.m_91087_().f_91066_.f_92095_.m_90857_() && EntityUtils.isPlayerPassengerOf(pEntity);
    }

    public static void removeRider(ParanogmiusEntity paranogmius, Player pRider) {
        if (pRider.m_20202_() == paranogmius) {
            paranogmius.m_8127_();
        }
    }
}

