/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class IngredientCount {
    protected final Ingredient ing;
    protected final int count;

    public static IngredientCount fromBuffer(FriendlyByteBuf buf) {
        Ingredient ing = Ingredient.m_43940_((FriendlyByteBuf)buf);
        int count = buf.readInt();
        return new IngredientCount(ing, count);
    }

    public static IngredientCount fromJson(JsonObject obj) {
        int count = Math.max(1, GsonHelper.m_13824_((JsonObject)obj, (String)"count", (int)1));
        JsonElement ingElement = obj.get("ingredient");
        Ingredient ing = Ingredient.m_43917_((JsonElement)ingElement);
        return new IngredientCount(ing, count);
    }

    public IngredientCount(Ingredient ing, int count) {
        this.ing = ing;
        this.count = Math.max(1, count);
    }

    public void toNetwork(FriendlyByteBuf buf) {
        this.ing.m_43923_(buf);
        buf.writeInt(this.count);
    }

    public boolean shrink(ItemStack stack) {
        if (this.test(stack)) {
            stack.m_41774_(this.count);
            return true;
        }
        return false;
    }

    public JsonElement toJson() {
        JsonObject obj = new JsonObject();
        if (this.count != 1) {
            obj.addProperty("count", (Number)this.count);
        }
        obj.add("ingredient", this.ing.m_43942_());
        return obj;
    }

    public boolean test(ItemStack stack) {
        if (this.ing.test(stack)) {
            return this.count <= stack.m_41613_();
        }
        return false;
    }

    public Ingredient getIngredient() {
        return this.ing;
    }

    public int getCount() {
        return this.count;
    }

    public Ingredient toIngredientWithCounts() {
        return Ingredient.m_43927_((ItemStack[])((ItemStack[])Arrays.stream(this.getIngredient().m_43908_()).peek(item -> item.m_41764_(this.getCount())).toArray(ItemStack[]::new)));
    }
}

