/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;

public class ScreenUtils {
    private static long startTime = System.currentTimeMillis();

    public static int getScaledInt(int progress, int max, int scale) {
        if (max == 0) {
            throw new IllegalArgumentException("the max must not be zero");
        }
        progress = Math.min(progress, max);
        return progress * scale / max;
    }

    public static void renderImageAnimationBottomTop(GuiGraphics graphics, ResourceLocation texture, int left, int top, int u, int v, int width, int height, int progress, int maxProgress) {
        if (progress > 0) {
            int scale = ScreenUtils.getScaledInt(progress, maxProgress, height);
            graphics.m_280218_(texture, left, top + height - scale, u, v + height - scale, width, scale);
        }
    }

    public static void renderBleeding(RenderGuiOverlayEvent.Pre pEvent, ResourceLocation overlay, int pWidth, int pHeight, MobEffectInstance effect) {
        PoseStack matrixStack = pEvent.getGuiGraphics().m_280168_();
        long elapsedTime = System.currentTimeMillis() - startTime;
        float pulsationEffect = 0.005f * (float)Math.sin((float)elapsedTime * 0.003f) + 0.005f;
        int remainingTicks = effect.m_19557_() - (int)(elapsedTime / 50L);
        float fadeAlpha = 1.0f;
        if (remainingTicks <= 60) {
            fadeAlpha = (float)remainingTicks / 60.0f;
        }
        if (!pEvent.getOverlay().id().equals((Object)VanillaGuiOverlay.CROSSHAIR.id())) {
            matrixStack.m_85836_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)fadeAlpha);
            pEvent.getGuiGraphics().m_280163_(overlay, 0, 0, 0.0f, 0.0f, pWidth, pHeight, pWidth, pHeight);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            pEvent.getGuiGraphics().m_280509_(0, 0, pWidth, pHeight, new Color(1.0f, 0.0f, 0.0f, pulsationEffect).getRGB());
            matrixStack.m_85849_();
        }
    }
}

