/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WorldUtils {
    public static boolean isBlockLoaded(@Nullable BlockGetter world, @Nonnull BlockPos pos) {
        if (world == null || !Level.m_46741_((BlockPos)pos)) {
            return false;
        }
        if (world instanceof LevelAccessor) {
            return ((LevelAccessor)world).isAreaLoaded(pos, 0);
        }
        return true;
    }

    @Nullable
    public static BlockEntity getTileEntity(BlockGetter world, BlockPos pos) {
        if (!WorldUtils.isBlockLoaded(world, pos)) {
            return null;
        }
        return world.m_7702_(pos);
    }

    @Nullable
    public static <T extends BlockEntity> T getTileEntity(@Nonnull Class<T> clazz, @Nullable BlockGetter world, @Nonnull BlockPos pos) {
        BlockEntity te = WorldUtils.getTileEntity(world, pos);
        if (te == null) {
            return null;
        }
        if (clazz.isInstance(te)) {
            return (T)((BlockEntity)clazz.cast(te));
        }
        return null;
    }

    @Nullable
    public static <T extends Entity> T getEntity(@Nonnull Class<T> clazz, @Nullable Level world, int entityId) {
        Entity e = world.m_6815_(entityId);
        if (e == null) {
            return null;
        }
        if (clazz.isInstance(e)) {
            return (T)((Entity)clazz.cast(e));
        }
        return null;
    }
}

