/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.util.misc;

import java.awt.Color;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public record EventData(DataType pDataType, Object pValue) {
    public void write(FriendlyByteBuf pBuf) {
        pBuf.m_130068_((Enum)this.pDataType);
        switch (this.pDataType) {
            case DOUBLE: {
                pBuf.writeDouble(this.asDouble());
                break;
            }
            case FLOAT: {
                pBuf.writeFloat(this.asFloat());
                break;
            }
            case INTEGER: {
                pBuf.writeInt(this.asInteger());
                break;
            }
            case STRING: {
                pBuf.m_130070_(this.asString());
                break;
            }
            case BOOLEAN: {
                pBuf.writeBoolean(this.asBoolean());
                break;
            }
            case ITEM_STACK: {
                pBuf.m_130055_(this.asItemStack());
                break;
            }
            case VECTOR_3: {
                Vec3 vec3 = this.asVector3();
                pBuf.writeDouble(vec3.f_82479_);
                pBuf.writeDouble(vec3.f_82480_);
                pBuf.writeDouble(vec3.f_82479_);
                break;
            }
            case UUID: {
                UUID uuid = this.asUUID();
                pBuf.writeLong(uuid.getMostSignificantBits());
                pBuf.writeLong(uuid.getLeastSignificantBits());
                break;
            }
            case COLOR: {
                pBuf.writeInt(this.asColor().getRGB());
                break;
            }
            case COMPOUND: {
                pBuf.m_130079_(this.asCompound());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + this.pDataType);
            }
        }
    }

    public static EventData read(FriendlyByteBuf pBuf) {
        DataType type = (DataType)pBuf.m_130066_(DataType.class);
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case DataType.DOUBLE -> new EventData(type, pBuf.readDouble());
            case DataType.FLOAT -> new EventData(type, Float.valueOf(pBuf.readFloat()));
            case DataType.INTEGER -> new EventData(type, pBuf.readInt());
            case DataType.STRING -> new EventData(type, pBuf.m_130277_());
            case DataType.BOOLEAN -> new EventData(type, pBuf.readBoolean());
            case DataType.ITEM_STACK -> new EventData(type, pBuf.m_130267_());
            case DataType.VECTOR_3 -> new EventData(type, new Vec3(pBuf.readDouble(), pBuf.readDouble(), pBuf.readDouble()));
            case DataType.UUID -> new EventData(type, new UUID(pBuf.readLong(), pBuf.readLong()));
            case DataType.COLOR -> new EventData(type, new Color(pBuf.readInt()));
            case DataType.COMPOUND -> new EventData(type, pBuf.m_130260_());
        };
    }

    public ItemStack asItemStack() {
        return (ItemStack)this.pValue;
    }

    public float asFloat() {
        return ((Float)this.pValue).floatValue();
    }

    public Vec3 asVector3() {
        return (Vec3)this.pValue;
    }

    public int asInteger() {
        return (Integer)this.pValue;
    }

    public boolean asBoolean() {
        return (Boolean)this.pValue;
    }

    public String asString() {
        return (String)this.pValue;
    }

    public double asDouble() {
        return (Double)this.pValue;
    }

    public Color asColor() {
        return (Color)this.pValue;
    }

    public UUID asUUID() {
        return (UUID)this.pValue;
    }

    public CompoundTag asCompound() {
        return (CompoundTag)this.pValue;
    }

    public static EventData valueVector3(Vec3 pVector3) {
        return new EventData(DataType.VECTOR_3, pVector3);
    }

    public static EventData valueCompound(CompoundTag pCompound) {
        return new EventData(DataType.COMPOUND, pCompound);
    }

    public static EventData valueItemStack(ItemStack pItemStack) {
        return new EventData(DataType.ITEM_STACK, pItemStack);
    }

    public static EventData valueFloat(float pFloat) {
        return new EventData(DataType.FLOAT, Float.valueOf(pFloat));
    }

    public static EventData valueDouble(double pDouble) {
        return new EventData(DataType.DOUBLE, pDouble);
    }

    public static EventData valueInteger(int pInteger) {
        return new EventData(DataType.INTEGER, pInteger);
    }

    public static EventData valueBoolean(boolean pBoolean) {
        return new EventData(DataType.BOOLEAN, pBoolean);
    }

    public static EventData valueString(String pString) {
        return new EventData(DataType.STRING, pString);
    }

    public static EventData valueUUID(UUID pUUID) {
        return new EventData(DataType.UUID, pUUID);
    }

    public static enum DataType {
        VECTOR_3,
        FLOAT,
        DOUBLE,
        INTEGER,
        STRING,
        UUID,
        COLOR,
        COMPOUND,
        BOOLEAN,
        ITEM_STACK;

    }
}

