/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.util.misc;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.reaper.ancientnature.common.util.misc.CommonEventProcessor;
import net.reaper.ancientnature.common.util.misc.EventData;

public class EventHandlerRegistry {
    private static final Logger LOGGER = Logger.getLogger(EventHandlerRegistry.class.getName());
    public Map<Integer, EventProcessor> eventHandlers = new ConcurrentHashMap<Integer, EventProcessor>();

    public void handleEvent(net.minecraft.world.level.Level pLevel, BlockPos pBlockPos, int pEventId, EventData[] pEventData) {
        EventProcessor processor = this.eventHandlers.getOrDefault(pEventId, (blockPos, level, eventData) -> LOGGER.log(Level.WARNING, "No handler found for event ID: {0}", pEventId));
        try {
            processor.handle(pBlockPos, pLevel, pEventData);
        }
        catch (Throwable throwable) {
            throw new ReportedException(CrashReport.m_127521_((Throwable)throwable, (String)("Error handling event ID: " + pEventId)));
        }
    }

    public EventHandlerRegistry register(int pEventId, EventProcessor pProcessor) {
        this.eventHandlers.put(pEventId, pProcessor);
        return this;
    }

    @FunctionalInterface
    public static interface EventProcessor {
        public void handle(BlockPos var1, net.minecraft.world.level.Level var2, EventData[] var3);
    }

    public static class LevelEventHandler {
        public static LevelEventHandler INSTANCE = new LevelEventHandler();
        public Map<String, CommonEventProcessor> serverListeners = new ConcurrentHashMap<String, CommonEventProcessor>();

        public void processCommonEvent(ServerLevel pServerLevel, BlockPos pBlockPos, int pEventId, EventData[] pEventData) {
            this.serverListeners.forEach((key, listener) -> listener.onProcessEvent(pServerLevel, pBlockPos, pEventId, pEventData));
        }

        public void addCommonListener(ResourceLocation pResourceLocation, CommonEventProcessor pProcessor) {
            this.serverListeners.put(pResourceLocation.toString(), pProcessor);
        }

        public static void registerCommonHandler(ResourceLocation pResourceLocation, CommonEventProcessor pProcessor) {
            INSTANCE.addCommonListener(pResourceLocation, pProcessor);
        }
    }
}

