/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.util.misc;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.reaper.ancientnature.common.util.EntityUtils;
import org.jetbrains.annotations.NotNull;

public interface IShakeScreenOnStep {
    public float getShakePower();

    default public float getMaxScreenShake() {
        return 0.7f;
    }

    default public boolean canEntityShake(@NotNull LivingEntity pEntity) {
        return !pEntity.isInFluidType() && pEntity.m_20096_();
    }

    default public float calculateShakeIntensity(float pAnimationSpeed) {
        float animationFactor = 1.0f + pAnimationSpeed * 0.3f;
        return 0.2f * animationFactor;
    }

    default public void handleScreenShake() {
        List<LivingEntity> entityList;
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null && (entityList = EntityUtils.getEntitiesAroundSelf(LivingEntity.class, (Entity)localPlayer, 8.0f, 8.0f, false)) != null && !entityList.isEmpty()) {
            for (LivingEntity entity : entityList) {
                if (!this.canEntityShake(entity) || !EntityUtils.isEntityStepping(entity, this.getShakeFrequency(), this.calculateShakeIntensity(entity.f_267362_.m_267731_())) || entity == localPlayer) continue;
                float distanceFactor = this.getShakeDistance() / entity.m_20270_((Entity)localPlayer) / 8.0f;
                float f = Math.min(distanceFactor * this.getShakePower(), this.getMaxScreenShake());
            }
        }
    }

    public float getShakeFrequency();

    public float getShakeDistance();
}

