/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.worldgen.tree.trunk;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.reaper.ancientnature.common.block.ItemDropperBlock;
import net.reaper.ancientnature.common.worldgen.tree.ANTrunkPlacerTypes;
import net.reaper.ancientnature.core.registry.ANBlocks;

public class GinkgoTrunkPlacer
extends TrunkPlacer {
    public static final Codec<GinkgoTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> GinkgoTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, GinkgoTrunkPlacer::new));

    public GinkgoTrunkPlacer(int pBaseHeight, int pHeightRandA, int pHeightRandB) {
        super(pBaseHeight, pHeightRandA, pHeightRandB);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)ANTrunkPlacerTypes.GINKGO_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration pConfig) {
        BlockPos.MutableBlockPos mutable = pPos.m_122032_();
        BlockPos below = mutable.m_7495_();
        GinkgoTrunkPlacer.m_226169_((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (BlockPos)below, (TreeConfiguration)pConfig);
        ArrayList list = Lists.newArrayList();
        boolean isGoldenTree = pConfig.f_161213_.m_213972_(pRandom, pPos).m_60713_((Block)ANBlocks.GOLDEN_GINKGO_LEAVES.get());
        for (int y = 0; y <= pFreeTreeHeight; ++y) {
            BlockPos logPos = pPos.m_6630_(y);
            if (y == 1 && isGoldenTree && pRandom.m_188499_()) {
                Direction randomDirection = Direction.Plane.HORIZONTAL.m_235690_(pRandom);
                pBlockSetter.accept(logPos, (BlockState)((BlockState)((ItemDropperBlock)((Object)ANBlocks.AMBER_GINKGO_LOG.get())).m_49966_().m_61124_((Property)ItemDropperBlock.f_55923_, (Comparable)Direction.Axis.Y)).m_61124_((Property)ItemDropperBlock.FACING, (Comparable)randomDirection));
            } else {
                this.m_226187_(pLevel, pBlockSetter, pRandom, logPos, pConfig);
            }
            int branchLength = Math.max(1, (pFreeTreeHeight - y + 1) / 3);
            if (y < 2 || y % 3 != 2) continue;
            for (int face = 0; face < 4; ++face) {
                Direction facing = Direction.m_122407_((int)face);
                BlockPos branchPos = logPos.m_121955_(facing.m_122436_());
                this.m_226187_(pLevel, pBlockSetter, pRandom, branchPos, pConfig);
                list.add(new FoliagePlacer.FoliageAttachment(branchPos.m_6630_(2), -1, false));
                list.add(new FoliagePlacer.FoliageAttachment(branchPos.m_6630_(3), -1, false));
                Direction side1 = facing.m_122427_();
                BlockPos sidePos1 = branchPos.m_121945_(side1);
                list.add(new FoliagePlacer.FoliageAttachment(sidePos1.m_6630_(2), -1, false));
                list.add(new FoliagePlacer.FoliageAttachment(sidePos1.m_6630_(3), -1, false));
                for (int z = 0; z < branchLength; ++z) {
                    BlockPos branchLogPos = branchPos.m_6630_(z / 2 + 1).m_5484_(facing, z + 1);
                    this.m_226187_(pLevel, pBlockSetter, pRandom, branchLogPos, pConfig);
                    list.add(new FoliagePlacer.FoliageAttachment(branchLogPos.m_6630_(2), -1, false));
                    list.add(new FoliagePlacer.FoliageAttachment(branchLogPos.m_6630_(1), -2, false));
                }
            }
        }
        list.add(new FoliagePlacer.FoliageAttachment(mutable.m_6630_(pFreeTreeHeight + 2), 0, false));
        list.add(new FoliagePlacer.FoliageAttachment(mutable.m_6630_(3), -1, false));
        if (pFreeTreeHeight > 13) {
            int additionalHeight = pFreeTreeHeight - 14;
            for (int i = 0; i <= additionalHeight; ++i) {
                list.add(new FoliagePlacer.FoliageAttachment(mutable.m_6630_(4 + i).m_7918_(2, 0, 2), -2, false));
                list.add(new FoliagePlacer.FoliageAttachment(mutable.m_6630_(4 + i).m_7918_(2, 0, -2), -2, false));
                list.add(new FoliagePlacer.FoliageAttachment(mutable.m_6630_(4 + i).m_7918_(-2, 0, 2), -2, false));
                list.add(new FoliagePlacer.FoliageAttachment(mutable.m_6630_(4 + i).m_7918_(-2, 0, -2), -2, false));
                list.add(new FoliagePlacer.FoliageAttachment(mutable.m_6630_(5 + i), 1, false));
            }
        }
        return list;
    }
}

