/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.core.compat.jade;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.reaper.ancientnature.common.base.BaseAnimal;
import net.reaper.ancientnature.common.entity.ai.hunger.HungerController;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum HungerProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        if (accessor.getServerData().m_128441_("Hunger") && accessor.getServerData().m_128441_("MaxHunger")) {
            int hunger = accessor.getServerData().m_128451_("Hunger");
            int maxHunger = accessor.getServerData().m_128451_("MaxHunger");
            int percent = (int)((float)hunger / (float)maxHunger * 100.0f);
            tooltip.add((Component)Component.m_237110_((String)"tooltip.ancientnature.hunger", (Object[])new Object[]{percent}));
        }
    }

    public void appendServerData(CompoundTag tag, EntityAccessor accessor) {
        Entity entity = accessor.getEntity();
        if (entity instanceof BaseAnimal) {
            BaseAnimal animal = (BaseAnimal)entity;
            HungerController hungerController = animal.hunger;
            if (hungerController != null) {
                tag.m_128405_("Hunger", animal.getHunger());
                tag.m_128405_("MaxHunger", hungerController.getMaxHunger());
            }
        }
    }

    public ResourceLocation getUid() {
        return new ResourceLocation("ancientnature", "hunger");
    }
}

