/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.core.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="ancientnature", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AncientNatureConfig {
    public static final ForgeConfigSpec SPEC;
    public static ForgeConfigSpec.BooleanValue CAMERASHAKE;
    public static ForgeConfigSpec.BooleanValue CAMERATILT;
    public static ForgeConfigSpec.ConfigValue<Boolean> PREHISTORICANIMALOVERWORLDSPAWNING;
    public static final ForgeConfigSpec.IntValue BLAZEPOWDERBURNTIME;
    public static final ForgeConfigSpec.IntValue MAXFUEL;
    public static final ForgeConfigSpec.IntValue MAXHEATING;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("Revival Stand");
        builder.comment("Defines the max fuel the Revival Stand will need in order to function");
        MAXFUEL = builder.defineInRange("maxFuel", 1000, 10, Integer.MAX_VALUE);
        builder.comment("Defines what the Revival Stand can heat at max per tick");
        MAXHEATING = builder.defineInRange("maxHeating", 10, 1, 1000000);
        builder.comment("Defines how much fuel Blaze Powder produces in the Revival Stand");
        BLAZEPOWDERBURNTIME = builder.defineInRange("blazePowderFuelTime", 500, 10, 1000000);
        builder.pop();
        builder.push("---Camera---");
        CAMERASHAKE = builder.comment("Enable or disable camera shake effects").define("cameraShake", true);
        CAMERATILT = builder.comment("Tilt camera while riding mob: ").define("tiltCamera", true);
        builder.pop();
        PREHISTORICANIMALOVERWORLDSPAWNING = builder.comment("Turn Prehistoric est overworld spawning ON or OFF").define("prehistoricAnimalOverworldSpawning", false);
        SPEC = builder.build();
    }
}

