/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.core.datagen.server.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.reaper.ancientnature.AncientNature;
import net.reaper.ancientnature.common.recipe.BrushingRecipe;
import org.jetbrains.annotations.Nullable;

public class BrushRecipeBuilder {
    protected float probability = 0.2f;
    protected Ingredient brush = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_271356_});
    protected Ingredient input;
    protected final ItemStack output;

    public static BrushRecipeBuilder builder(ItemLike output) {
        return BrushRecipeBuilder.builder(output, 1);
    }

    public static BrushRecipeBuilder builder(ItemLike output, int count) {
        return BrushRecipeBuilder.builder(new ItemStack(output, count));
    }

    public static BrushRecipeBuilder builder(ItemStack output) {
        return new BrushRecipeBuilder(output);
    }

    public BrushRecipeBuilder(ItemStack output) {
        this.output = output;
    }

    public BrushRecipeBuilder probability(float probability) {
        if (this.probability != probability) {
            this.probability = probability;
        }
        return this;
    }

    public BrushRecipeBuilder brush(TagKey<Item> brush) {
        return this.brush(Ingredient.m_204132_(brush));
    }

    public BrushRecipeBuilder brush(ItemLike ... brushes) {
        return this.brush(Ingredient.m_43929_((ItemLike[])brushes));
    }

    public BrushRecipeBuilder brush(Ingredient ing) {
        this.brush = ing;
        return this;
    }

    public BrushRecipeBuilder input(TagKey<Item> inputs) {
        return this.input(Ingredient.m_204132_(inputs));
    }

    public BrushRecipeBuilder input(ItemLike ... inputs) {
        return this.input(Ingredient.m_43929_((ItemLike[])inputs));
    }

    public BrushRecipeBuilder input(Ingredient ing) {
        this.input = ing;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        this.build(consumer, ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_()));
    }

    public void build(Consumer<FinishedRecipe> consumer, String id) {
        this.build(consumer, AncientNature.modLoc(id));
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.input == null) {
            throw new IllegalArgumentException("input sint defines for recipe: " + id);
        }
        consumer.accept(new Result(id, this.brush, this.input, this.probability, this.output));
    }

    public static class Result
    implements FinishedRecipe {
        protected final ResourceLocation id;
        protected final Ingredient brush;
        protected final Ingredient input;
        protected final float probability;
        protected final ItemStack output;

        public Result(ResourceLocation id, Ingredient brush, Ingredient input, float probability, ItemStack output) {
            this.id = id;
            this.brush = brush;
            this.input = input;
            this.probability = probability;
            this.output = output;
        }

        public void m_7917_(JsonObject pJson) {
            if (this.probability != 0.2f) {
                pJson.addProperty("probability", (Number)Float.valueOf(this.probability));
            }
            pJson.add("brush", this.brush.m_43942_());
            pJson.add("input", this.input.m_43942_());
            JsonObject obj = new JsonObject();
            obj.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_()).toString());
            if (this.output.m_41613_() > 1) {
                obj.addProperty("count", (Number)this.output.m_41613_());
            }
            pJson.add("output", (JsonElement)obj);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return BrushingRecipe.SERIALIZER;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

