/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.core.datagen.server.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.reaper.ancientnature.common.recipe.RevivalStandRecipe;
import net.reaper.ancientnature.common.util.IngredientCount;
import net.reaper.ancientnature.common.util.ResourceLocationUtils;
import org.jetbrains.annotations.Nullable;

public class RevivalStandRecipeBuilder {
    protected final ItemStack eggs;
    protected int amberInfusionTime;
    protected int fossilInfusionTime;
    protected Ingredient baseRoe;
    protected IngredientCount fossil;
    protected IngredientCount amber;

    public static RevivalStandRecipeBuilder builder(ItemLike egg) {
        return RevivalStandRecipeBuilder.builder(egg, 1);
    }

    public static RevivalStandRecipeBuilder builder(ItemLike egg, int count) {
        return RevivalStandRecipeBuilder.builder(new ItemStack(egg, Mth.m_14045_((int)count, (int)1, (int)1)));
    }

    public static RevivalStandRecipeBuilder builder(ItemStack egg) {
        return new RevivalStandRecipeBuilder(egg);
    }

    public RevivalStandRecipeBuilder(ItemStack eggs) {
        this.eggs = eggs;
        this.eggs.m_41764_(Mth.m_14045_((int)this.eggs.m_41613_(), (int)1, (int)1));
    }

    public RevivalStandRecipeBuilder fossil(TagKey<Item> fossils) {
        return this.fossil(fossils, 1);
    }

    public RevivalStandRecipeBuilder fossil(ItemLike ... fossils) {
        return this.fossil(1, fossils);
    }

    public RevivalStandRecipeBuilder fossil(Ingredient fossil) {
        return this.fossil(fossil, 1);
    }

    public RevivalStandRecipeBuilder fossil(TagKey<Item> fossils, int count) {
        return this.fossil(Ingredient.m_204132_(fossils), count);
    }

    public RevivalStandRecipeBuilder fossil(int count, ItemLike ... fossils) {
        return this.fossil(Ingredient.m_43929_((ItemLike[])fossils), count);
    }

    public RevivalStandRecipeBuilder fossil(Ingredient fossil, int count) {
        this.fossil = new IngredientCount(fossil, count);
        return this;
    }

    public RevivalStandRecipeBuilder amber(TagKey<Item> ambers) {
        return this.amber(ambers, 1);
    }

    public RevivalStandRecipeBuilder amber(ItemLike ... ambers) {
        return this.amber(1, ambers);
    }

    public RevivalStandRecipeBuilder amber(Ingredient amber) {
        return this.amber(amber, 1);
    }

    public RevivalStandRecipeBuilder amber(TagKey<Item> ambers, int count) {
        return this.amber(Ingredient.m_204132_(ambers), count);
    }

    public RevivalStandRecipeBuilder amber(int count, ItemLike ... ambers) {
        return this.amber(Ingredient.m_43929_((ItemLike[])ambers), count);
    }

    public RevivalStandRecipeBuilder amber(Ingredient amber, int count) {
        this.amber = new IngredientCount(amber, count);
        return this;
    }

    public RevivalStandRecipeBuilder amberInfusionTime(int amberInfusionTime) {
        this.amberInfusionTime = Math.max(1, amberInfusionTime);
        return this;
    }

    public RevivalStandRecipeBuilder fossilInfusionTime(int fossilInfusionTime) {
        this.fossilInfusionTime = Math.max(1, fossilInfusionTime);
        return this;
    }

    public RevivalStandRecipeBuilder baseRoe(TagKey<Item> baseRoe) {
        return this.baseRoe(Ingredient.m_204132_(baseRoe));
    }

    public RevivalStandRecipeBuilder baseRoe(ItemLike ... baseRoe) {
        return this.baseRoe(Ingredient.m_43929_((ItemLike[])baseRoe));
    }

    public RevivalStandRecipeBuilder baseRoe(Ingredient baseRoe) {
        this.baseRoe = baseRoe;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        this.build(consumer, ForgeRegistries.ITEMS.getKey((Object)this.eggs.m_41720_()));
    }

    public void build(Consumer<FinishedRecipe> consumer, String suffix) {
        this.build(consumer, ResourceLocationUtils.extend(ForgeRegistries.ITEMS.getKey((Object)this.eggs.m_41720_()), suffix));
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        this.validate();
        consumer.accept(new Result(ResourceLocationUtils.prepend(id, "revival_stand/"), this.fossil, this.amber, this.baseRoe, this.amberInfusionTime, this.fossilInfusionTime, this.eggs));
    }

    protected void validate() {
        if (this.fossil == null) {
            throw new IllegalStateException("the fossil must not be null, every recipe has to have a fossil");
        }
        if (this.amber == null) {
            throw new IllegalStateException("the amber must not be null, every recipe has to have a amber");
        }
        if (this.amberInfusionTime <= 0) {
            throw new IllegalStateException("the amber infusion time has to be set to a higher value then 0");
        }
        if (this.fossilInfusionTime <= 0) {
            throw new IllegalStateException("the fossil infusion time has to be set to a higher value then 0");
        }
    }

    protected static class Result
    implements FinishedRecipe {
        protected final ResourceLocation id;
        protected final IngredientCount fossil;
        protected final IngredientCount amber;
        protected final Ingredient basRoe;
        protected final int amberInfusionTime;
        protected final int fossilInfusionTime;
        protected final ItemStack eggs;

        public Result(ResourceLocation id, IngredientCount fossil, IngredientCount amber, Ingredient basRoe, int amberInfusionTime, int fossilInfusionTime, ItemStack eggs) {
            this.id = id;
            this.fossil = fossil;
            this.amber = amber;
            this.basRoe = basRoe;
            this.amberInfusionTime = amberInfusionTime;
            this.fossilInfusionTime = fossilInfusionTime;
            this.eggs = eggs;
        }

        public void m_7917_(JsonObject pJson) {
            JsonElement fossilJson = this.fossil.toJson();
            pJson.add("fossil", fossilJson);
            JsonElement amberJson = this.amber.toJson();
            pJson.add("amber", amberJson);
            if (this.amberInfusionTime != 200) {
                pJson.addProperty("amberInfusionTime", (Number)this.amberInfusionTime);
            }
            if (this.fossilInfusionTime != 200) {
                pJson.addProperty("fossilInfusionTime", (Number)this.fossilInfusionTime);
            }
            if (this.basRoe != null) {
                JsonElement baseEl = this.basRoe.m_43942_();
                pJson.add("base_roe", baseEl);
            }
            JsonObject eggObject = new JsonObject();
            eggObject.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.eggs.m_41720_()).toString());
            if (this.eggs.m_41613_() != 1) {
                eggObject.addProperty("count", (Number)this.eggs.m_41613_());
            }
            pJson.add("egg", (JsonElement)eggObject);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return RevivalStandRecipe.SERIALIZER;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

