/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.core.network.packets;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.reaper.ancientnature.common.util.misc.IMouseInput;

public class EntityRoarKeyPacket {
    public int vehicleId;
    public int riderId;

    public <T extends LivingEntity> EntityRoarKeyPacket(int pVehicleId) {
        this.vehicleId = pVehicleId;
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        this.riderId = localPlayer != null ? Minecraft.m_91087_().f_91074_.m_19879_() : -1;
    }

    public static EntityRoarKeyPacket read(FriendlyByteBuf pBuf) {
        return new EntityRoarKeyPacket(pBuf.readInt());
    }

    public static void write(EntityRoarKeyPacket pMessage, FriendlyByteBuf pBuf) {
        pBuf.writeInt(pMessage.vehicleId);
    }

    public static void handle(EntityRoarKeyPacket pMessage, Supplier<NetworkEvent.Context> pContext) {
        pContext.get().enqueueWork(() -> {
            ServerPlayer senderPlayer = ((NetworkEvent.Context)pContext.get()).getSender();
            if (((NetworkEvent.Context)pContext.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                senderPlayer = Minecraft.m_91087_().f_91074_;
            }
            if (senderPlayer != null) {
                Entity vehicle = senderPlayer.m_9236_().m_6815_(pMessage.vehicleId);
                Entity rider = senderPlayer.m_9236_().m_6815_(pMessage.riderId);
                if (vehicle instanceof IMouseInput) {
                    IMouseInput mouseInput = (IMouseInput)vehicle;
                    if (rider instanceof Player && rider.m_20365_(vehicle)) {
                        mouseInput.onMouseClick(1);
                    }
                }
            }
        });
        pContext.get().setPacketHandled(true);
    }
}

