/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.core.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MessageMultipartInteract {
    public int creatureID;
    public float dmg;

    public MessageMultipartInteract(int creatureID, float dmg) {
        this.creatureID = creatureID;
        this.dmg = dmg;
    }

    public MessageMultipartInteract() {
    }

    public static MessageMultipartInteract read(FriendlyByteBuf buf) {
        return new MessageMultipartInteract(buf.readInt(), buf.readFloat());
    }

    public static void write(MessageMultipartInteract message, FriendlyByteBuf buf) {
        buf.writeInt(message.creatureID);
        buf.writeFloat(message.dmg);
    }

    public static class Handler {
        public static void handle(MessageMultipartInteract message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                LivingEntity livingEntity;
                double dist;
                Entity entity;
                ServerPlayer player = context.getSender();
                if (player != null && (entity = player.m_9236_().m_6815_(message.creatureID)) instanceof LivingEntity && (dist = (double)player.m_20270_((Entity)(livingEntity = (LivingEntity)entity))) < 100.0) {
                    if (message.dmg > 0.0f) {
                        livingEntity.m_6469_(player.m_9236_().m_269111_().m_269333_((LivingEntity)player), message.dmg);
                    } else {
                        livingEntity.m_6096_((Player)player, InteractionHand.MAIN_HAND);
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }
}

