/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.core.network.packets;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.reaper.ancientnature.common.util.misc.EventData;
import net.reaper.ancientnature.common.util.misc.EventHandlerRegistry;

public class MessageServerEntityEvent {
    private final BlockPos blockPos;
    private final int eventId;
    private final EventData[] eventData;

    public MessageServerEntityEvent(BlockPos pBlockPos, int pEventId, EventData ... pEventData) {
        this.blockPos = pBlockPos;
        this.eventId = pEventId;
        this.eventData = pEventData;
    }

    public static void write(MessageServerEntityEvent message, FriendlyByteBuf pBuf) {
        pBuf.m_130064_(message.blockPos);
        pBuf.writeInt(message.eventId);
        pBuf.writeInt(message.eventData.length);
        for (EventData argument : message.eventData) {
            argument.write(pBuf);
        }
    }

    public static MessageServerEntityEvent read(FriendlyByteBuf pBuf) {
        BlockPos pos = pBuf.m_130135_();
        int eventId = pBuf.readInt();
        int length = pBuf.readInt();
        EventData[] eventData = new EventData[length];
        for (int i = 0; i < eventData.length; ++i) {
            eventData[i] = EventData.read(pBuf);
        }
        return new MessageServerEntityEvent(pos, eventId, eventData);
    }

    public static void handle(MessageServerEntityEvent pMessage, Supplier<NetworkEvent.Context> pContext) {
        ServerPlayer sender;
        NetworkEvent.Context context = pContext.get();
        if (context.getDirection().getReceptionSide().isServer() && (sender = context.getSender()) != null) {
            context.enqueueWork(() -> {
                Level patt2023$temp = sender.m_9236_();
                if (patt2023$temp instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)patt2023$temp;
                    EventHandlerRegistry.LevelEventHandler.INSTANCE.processCommonEvent(serverLevel, pMessage.blockPos, pMessage.eventId, pMessage.eventData);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

