/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.core.registry;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.reaper.ancientnature.client.particle.DeepslateDustParticle;
import net.reaper.ancientnature.client.particle.DodoFeatherParticle;
import net.reaper.ancientnature.client.particle.MudParticle;
import net.reaper.ancientnature.client.particle.SoundWaveParticle;
import net.reaper.ancientnature.client.particle.StoneParticle;
import net.reaper.ancientnature.client.particle.option.DodoFeatherData;
import net.reaper.ancientnature.client.particle.option.SoundWaveData;
import net.reaper.ancientnature.common.particle.BleedingParticle;
import net.reaper.ancientnature.common.particle.LeafsParticle;
import net.reaper.ancientnature.common.particle.RevivalStandParticle;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ANParticles {
    public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"ancientnature");
    public static final RegistryObject<SimpleParticleType> MUD_PARTICLE = ANParticles.reg("mud");
    public static final RegistryObject<SimpleParticleType> STONE_PARTICLE = ANParticles.reg("stone");
    public static final RegistryObject<SimpleParticleType> GINKGO_PARTICLE = ANParticles.reg("ginkgo");
    public static final RegistryObject<SimpleParticleType> BLEEDING_PARTICLE = ANParticles.reg("bleeding");
    public static final RegistryObject<SimpleParticleType> GOLDEN_GINKGO_PARTICLE = ANParticles.reg("golden_ginkgo");
    public static final RegistryObject<SimpleParticleType> REVIVAL_STAND_PARTICLE = ANParticles.reg("revival_stand");
    public static final RegistryObject<SimpleParticleType> DEEPSLATE_DUST_PARTICLE = ANParticles.reg("deepslate_dust");
    public static final RegistryObject<ParticleType<DodoFeatherData>> DODO_FEATHER = PARTICLES.register("dodo_feather", () -> ANParticles.regWithOptions(true, DodoFeatherData.DESERIALIZER, type -> DodoFeatherData.CODEC));
    public static final RegistryObject<ParticleType<SoundWaveData>> SOUND_WAVE = PARTICLES.register("sound_wave", () -> ANParticles.regWithOptions(true, SoundWaveData.DESERIALIZER, type -> SoundWaveData.CODEC));

    @NotNull
    private static RegistryObject<SimpleParticleType> reg(String name, boolean overrideLimiter) {
        return PARTICLES.register(name + "_particle", () -> new SimpleParticleType(overrideLimiter));
    }

    @NotNull
    private static RegistryObject<SimpleParticleType> reg(String name) {
        return ANParticles.reg(name, false);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    private static <T extends ParticleOptions> ParticleType<T> regWithOptions(boolean overrideLimiter, @NotNull ParticleOptions.Deserializer<T> deserializer, final Function<ParticleType<T>, Codec<T>> codec) {
        return new ParticleType<T>(overrideLimiter, deserializer){

            @NotNull
            public Codec<T> m_7652_() {
                return (Codec)codec.apply(this);
            }
        };
    }

    @Mod.EventBusSubscriber(modid="ancientnature", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    private static class Events {
        private Events() {
        }

        @SubscribeEvent
        public static void onRegisterParticleProviders(@NotNull RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)REVIVAL_STAND_PARTICLE.get(), RevivalStandParticle.Provider::new);
            event.registerSpriteSet((ParticleType)BLEEDING_PARTICLE.get(), BleedingParticle.Provider::new);
            event.registerSpriteSet((ParticleType)GINKGO_PARTICLE.get(), LeafsParticle.Provider::new);
            event.registerSpriteSet((ParticleType)GOLDEN_GINKGO_PARTICLE.get(), LeafsParticle.Provider::new);
            event.registerSpriteSet((ParticleType)DEEPSLATE_DUST_PARTICLE.get(), DeepslateDustParticle.Provider::new);
            event.registerSpriteSet((ParticleType)STONE_PARTICLE.get(), StoneParticle.Provider::new);
            event.registerSpriteSet((ParticleType)MUD_PARTICLE.get(), MudParticle.Provider::new);
            event.registerSpriteSet((ParticleType)DODO_FEATHER.get(), DodoFeatherParticle.Provider::new);
            event.registerSpriteSet((ParticleType)SOUND_WAVE.get(), SoundWaveParticle.Provider::new);
        }
    }
}

