/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.core.registry;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.reaper.ancientnature.AncientNature;
import net.reaper.ancientnature.common.recipe.BrushingRecipe;
import net.reaper.ancientnature.common.recipe.RevivalStandRecipe;
import net.reaper.ancientnature.common.recipe.WaterWashingRecipe;

public class ANRecipes {
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"ancientnature");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"ancientnature");
    public static final RegistryObject<RecipeType<BrushingRecipe>> BRUSHING_RECIPE = ANRecipes.register("brushing_recipe", () -> BrushingRecipe.SERIALIZER);
    public static final RegistryObject<RecipeType<WaterWashingRecipe>> WATER_WASHING = ANRecipes.register("water_washing", () -> WaterWashingRecipe.SERIALIZER);
    public static final RegistryObject<RecipeType<RevivalStandRecipe>> REVIVAL_STAND_RECIPE = ANRecipes.register("revival_stand_recipe", () -> RevivalStandRecipe.SERIALIZER);

    public static <T extends Recipe<?>> RegistryObject<RecipeType<T>> register(String name, Supplier<RecipeSerializer<T>> serializer) {
        RegistryObject object = RECIPE_TYPES.register(name, () -> RecipeType.simple((ResourceLocation)AncientNature.modLoc(name)));
        RECIPE_SERIALIZERS.register(name, serializer);
        return object;
    }
}

