/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.core.util;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ANMath {
    private static final double QUARTER_PI = 0.7853981633974483;
    private static final double THREE_QUARTERS_PI = 2.356194490192345;

    @Contract(value="_ -> new")
    @NotNull
    public static Vec3 readVec3(@NotNull FriendlyByteBuf buf) {
        return new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    @Contract(value="_, _ -> param1")
    @NotNull
    public static FriendlyByteBuf writeVec3(@NotNull FriendlyByteBuf buf, @NotNull Vec3 vec3) {
        buf.writeDouble(vec3.m_7096_());
        buf.writeDouble(vec3.m_7098_());
        buf.writeDouble(vec3.m_7094_());
        return buf;
    }

    public static double calculateAccurateAtan2(double y, double x) {
        if (y < 0.0) {
            y = -y;
            if (x > 0.0) {
                double r = (x - y) / (x + y);
                return -(0.1963 * r * r * r - 0.9817 * r + 0.7853981633974483);
            }
            double r = (x + y) / (y - x);
            return -(0.1963 * r * r * r - 0.9817 * r + 2.356194490192345);
        }
        if (y == 0.0) {
            y = 1.0E-25;
        }
        if (x > 0.0) {
            double r = (x - y) / (x + y);
            return 0.1963 * r * r * r - 0.9817 * r + 0.7853981633974483;
        }
        double r = (x + y) / (y - x);
        return 0.1963 * r * r * r - 0.9817 * r + 2.356194490192345;
    }
}

