/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.core.util;

import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ANUtils {
    public static boolean isEntityInFront(@NotNull LivingEntity viewer, @NotNull LivingEntity target, double maxAngle) {
        Vec3 directionToTarget = target.m_146892_().m_82546_(viewer.m_146892_()).m_82541_();
        double i = viewer.m_20252_(1.0f).m_82526_(directionToTarget);
        return Math.acos(i) < maxAngle;
    }

    @Nullable
    public static Entity getEntityByUUID(Level level, UUID uuid) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (Entity entity : serverLevel.m_8583_()) {
                if (entity == null || !entity.m_20148_().equals(uuid)) continue;
                return entity;
            }
        }
        return null;
    }

    public static void performRiderAttack(@Nullable Mob attacker, float damage, double range) {
        Entity entity;
        Vec3 end;
        if (attacker == null) {
            return;
        }
        Vec3 start = attacker.m_146892_();
        EntityHitResult entityHit = ANUtils.getEntityHitResult(attacker, start, end = start.m_82549_(attacker.m_20154_().m_82490_(range)));
        if (entityHit != null && (entity = entityHit.m_82443_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            target.m_6469_(attacker.m_269291_().m_269333_((LivingEntity)attacker), damage);
        }
    }

    private static EntityHitResult getEntityHitResult(Mob attacker, Vec3 start, Vec3 end) {
        return ProjectileUtil.m_37304_((Level)attacker.m_9236_(), (Entity)attacker, (Vec3)start, (Vec3)end, (AABB)attacker.m_20191_().m_82369_(end.m_82546_(start)).m_82400_(1.0), entity -> entity != attacker && entity.m_6084_());
    }

    @Nullable
    public static Goal getCurrentGoal(@NotNull Mob mob) {
        return mob.f_21345_.m_148105_().stream().filter(WrappedGoal::m_7620_).map(WrappedGoal::m_26015_).findFirst().orElse(null);
    }

    public static class Entities {
        @Contract(value="_, _ -> false")
        public static boolean trySit(@Nullable Entity entity, @Nullable Player player) {
            LivingEntity vehicle;
            if (player != null && entity instanceof LivingEntity && (vehicle = (LivingEntity)entity).m_20197_().isEmpty() && player instanceof Player && player.m_20329_((Entity)vehicle)) {
                Entities.copyRot(vehicle, player);
                return true;
            }
            return false;
        }

        @NotNull
        public static <T extends LivingEntity> T copyRot(@NotNull T source, @NotNull T target) {
            target.m_146922_(source.m_146908_());
            target.m_146926_(source.m_146909_());
            target.f_20885_ = source.f_20885_;
            target.f_20883_ = source.f_20883_;
            return target;
        }
    }
}

