/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.io.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.reaper.ancientnature.AncientNature;
import net.reaper.ancientnature.common.entity.ai.hunger.diet.MobDiet;
import net.reaper.ancientnature.common.entity.ai.hunger.diet.entry.DietEntry;
import net.reaper.ancientnature.common.entity.ai.hunger.diet.entry.ItemEntry;
import net.reaper.ancientnature.common.entity.ai.hunger.diet.entry.TagEntry;
import org.jetbrains.annotations.NotNull;

public class MobDietConfig {
    private static final Path FOLDER = Path.of("config", "ancientnature", "diets");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(MobDiet.class, (Object)new MobDietAdapter()).create();

    @NotNull
    private static Path getDietFile(@NotNull ResourceLocation mobId) {
        return FOLDER.resolve(mobId.m_135815_() + "_diet.json");
    }

    @NotNull
    public static MobDiet loadOrCreate(@NotNull ResourceLocation mobId, @NotNull MobDiet defaultDiet) {
        MobDiet mobDiet;
        block9: {
            Path file = MobDietConfig.getDietFile(mobId);
            if (!Files.exists(file, new LinkOption[0])) {
                MobDietConfig.save(mobId, defaultDiet);
                return defaultDiet;
            }
            BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);
            try {
                mobDiet = (MobDiet)GSON.fromJson((Reader)reader, MobDiet.class);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    AncientNature.LOGGER.error("Failed to load diet for {}: {}", (Object)mobId, (Object)e);
                    return defaultDiet;
                }
            }
            ((Reader)reader).close();
        }
        return mobDiet;
    }

    public static void save(@NotNull ResourceLocation mobId, @NotNull MobDiet diet) {
        try {
            if (Files.notExists(FOLDER, new LinkOption[0])) {
                Files.createDirectories(FOLDER, new FileAttribute[0]);
            }
            Path file = MobDietConfig.getDietFile(mobId);
            try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((Object)diet, (Appendable)writer);
            }
        }
        catch (IOException e) {
            AncientNature.LOGGER.error("Failed to save diet for {}: {}", (Object)mobId, (Object)e);
        }
    }

    private static class MobDietAdapter
    implements JsonSerializer<MobDiet>,
    JsonDeserializer<MobDiet> {
        private MobDietAdapter() {
        }

        @NotNull
        public JsonElement serialize(@NotNull MobDiet src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            JsonArray foods = new JsonArray();
            JsonArray tags = new JsonArray();
            for (DietEntry entry : src.getAllEntries()) {
                if (entry instanceof ItemEntry) {
                    ItemEntry itemEntry = (ItemEntry)entry;
                    foods.add(ForgeRegistries.ITEMS.getKey((Object)itemEntry.item().m_5456_()).toString());
                    continue;
                }
                if (!(entry instanceof TagEntry)) continue;
                TagEntry tagEntry = (TagEntry)entry;
                tags.add(tagEntry.itemTag().f_203868_().toString());
            }
            json.add("foods", (JsonElement)foods);
            json.add("tags", (JsonElement)tags);
            return json;
        }

        @NotNull
        public MobDiet deserialize(@NotNull JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            MobDiet diet = new MobDiet();
            if (obj.has("foods")) {
                for (JsonElement e : obj.getAsJsonArray("foods")) {
                    ResourceLocation itemId = new ResourceLocation(e.getAsString());
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
                    if (item == null) continue;
                    diet.addFood((ItemLike)item);
                }
            }
            if (obj.has("tags")) {
                for (JsonElement e : obj.getAsJsonArray("tags")) {
                    ResourceLocation tagId = new ResourceLocation(e.getAsString());
                    diet.addFoodTag((TagKey<Item>)TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)tagId));
                }
            }
            return diet;
        }
    }
}

