/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.io.network.packet;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.reaper.ancientnature.api.common.animator.BaseAnimation;
import net.reaper.ancientnature.api.common.animator.IAnimateable;
import net.reaper.ancientnature.api.common.animator.IAnimation;
import net.reaper.ancientnature.api.io.network.AbstractNetworkPacket;
import net.reaper.ancientnature.api.io.network.PacketSide;
import net.reaper.ancientnature.api.io.network.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PacketSide(side=Side.CLIENT)
public class AnimationSyncPacket
extends AbstractNetworkPacket<AnimationSyncPacket> {
    private int entityId;
    private String animationName;
    private String next;
    private boolean stopFlag = false;

    public AnimationSyncPacket() {
    }

    public AnimationSyncPacket(int entityId, @NotNull String animationName, boolean stopFlag, @Nullable String next) {
        this.entityId = entityId;
        this.animationName = animationName;
        this.stopFlag = stopFlag;
        this.next = next;
    }

    @Override
    protected void read(@NotNull FriendlyByteBuf buf) {
        this.entityId = buf.m_130242_();
        this.animationName = buf.m_130277_();
        this.stopFlag = buf.readBoolean();
        this.next = buf.readBoolean() ? buf.m_130277_() : null;
    }

    @Override
    protected void write(@NotNull FriendlyByteBuf buf) {
        buf.m_130130_(this.entityId);
        buf.m_130070_(this.animationName);
        buf.writeBoolean(this.stopFlag);
        if (this.next != null) {
            buf.writeBoolean(true);
            buf.m_130070_(this.next);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    protected void execute(@NotNull Supplier<NetworkEvent.Context> context) {
        Entity entity;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (entity = level.m_6815_(this.entityId)) instanceof IAnimateable) {
            IAnimateable animateable = (IAnimateable)entity;
            IAnimation animation = animateable.getAnimator().getByName(this.animationName);
            if (this.stopFlag) {
                animation.stop();
            } else {
                if (animation instanceof BaseAnimation) {
                    BaseAnimation base = (BaseAnimation)animation;
                    base.setNextAnimation(this.next);
                }
                animation.start();
            }
        }
    }
}

