/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.io.network.packet;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.reaper.ancientnature.api.io.input.InputKey;
import net.reaper.ancientnature.api.io.input.InputableEntity;
import net.reaper.ancientnature.api.io.input.KeyPressType;
import net.reaper.ancientnature.api.io.network.AbstractNetworkPacket;
import net.reaper.ancientnature.api.io.network.PacketSide;
import net.reaper.ancientnature.api.io.network.Side;
import org.jetbrains.annotations.NotNull;

@PacketSide(side=Side.SERVER)
public class PlayerInputPacket
extends AbstractNetworkPacket<PlayerInputPacket> {
    private InputKey key;
    private KeyPressType type;

    public PlayerInputPacket() {
    }

    public PlayerInputPacket(@NotNull InputKey key, @NotNull KeyPressType type) {
        this.key = key;
        this.type = type;
    }

    @Override
    protected void read(@NotNull FriendlyByteBuf buf) {
        this.key = InputKey.values()[buf.readByte()];
        this.type = KeyPressType.values()[buf.readByte()];
    }

    @Override
    protected void write(@NotNull FriendlyByteBuf buf) {
        buf.writeByte(this.key.ordinal());
        buf.writeByte(this.type.ordinal());
    }

    @Override
    protected void execute(@NotNull Supplier<NetworkEvent.Context> context) {
        Entity entity;
        ServerPlayer player = context.get().getSender();
        if (player != null && player.m_20159_() && (entity = player.m_20201_()) instanceof InputableEntity) {
            InputableEntity inputable = (InputableEntity)entity;
            inputable.handleInput(this.key, this.type);
        }
    }
}

