/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.mixin.common;

import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.reaper.ancientnature.api.common.tag.EntityTag;
import net.reaper.ancientnature.api.common.tag.IEntityData;
import net.reaper.ancientnature.api.common.tag.IHasEntityTags;
import net.reaper.ancientnature.api.common.tag.TagBuilder;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Implements(value={@Interface(iface=IEntityData.class, prefix="an$")})
@Mixin(value={Entity.class})
public class EntityMixin {
    @Unique
    private static final EntityDataAccessor<CompoundTag> MOD_ENTITY_DATA = SynchedEntityData.m_135353_(Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void onInit(@NotNull EntityType<?> type, @NotNull Level level, @NotNull CallbackInfo ci) {
        this.an_getSelf().f_19804_.m_135372_(MOD_ENTITY_DATA, (Object)new CompoundTag());
        this.an_applyToEntityTags(entityTag -> entityTag.define(this.an_getSelf()));
    }

    @Inject(method={"saveWithoutId"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V", shift=At.Shift.AFTER)})
    public void onSaveWithoutId(@NotNull CompoundTag tag, @NotNull CallbackInfoReturnable<CompoundTag> cir) {
        tag.m_128365_("ModEntityData", (Tag)this.an$getModEntityData());
        this.an_applyToEntityTags(entityTag -> entityTag.write(this.an_getSelf(), tag));
    }

    @Inject(method={"load"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V", shift=At.Shift.AFTER)})
    public void onLoad(@NotNull CompoundTag tag, @NotNull CallbackInfo ci) {
        if (tag.m_128441_("ModEntityData")) {
            this.an_getSelf().f_19804_.m_135381_(MOD_ENTITY_DATA, (Object)tag.m_128469_("ModEntityData"));
        }
        this.an_applyToEntityTags(entityTag -> entityTag.read(this.an_getSelf(), tag));
    }

    @Unique
    private void an_applyToEntityTags(@NotNull Consumer<EntityTag<?>> consumer) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof IHasEntityTags) {
            IHasEntityTags provider = (IHasEntityTags)((Object)entityMixin);
            TagBuilder builder = new TagBuilder();
            provider.addTags(builder);
            for (EntityTag<?> tag : builder.build()) {
                consumer.accept(tag);
            }
        }
    }

    @NotNull
    public CompoundTag an$getModEntityData() {
        return (CompoundTag)this.an_getSelf().f_19804_.m_135370_(MOD_ENTITY_DATA);
    }

    @Unique
    @NotNull
    private Entity an_getSelf() {
        return (Entity)this;
    }
}

