/*
 * Decompiled with CFR 0.152.
 */
package net.nhatjs.js_furniture_mod.block.blockentity.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.nhatjs.js_furniture_mod.block.CoffeeTableBlock;
import net.nhatjs.js_furniture_mod.block.blockentity.client.CoffeeTableBlockEntity;
import net.nhatjs.js_furniture_mod.block.blockentity.client.renderer.CoffeeTableRenderState;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class CoffeeTableRenderer
implements BlockEntityRenderer<CoffeeTableBlockEntity, CoffeeTableRenderState> {
    private final ItemModelResolver itemModelResolver;
    private final Map<BlockPos, Integer> lastNonce = new HashMap<BlockPos, Integer>();

    public CoffeeTableRenderer(BlockEntityRendererProvider.Context ctx) {
        this.itemModelResolver = ctx.itemModelResolver();
    }

    public CoffeeTableRenderState createRenderState() {
        return new CoffeeTableRenderState();
    }

    public void extractRenderState(CoffeeTableBlockEntity blockEntity, CoffeeTableRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)state, tickProgress, cameraPos, crumblingOverlay);
        state.pos = blockEntity.getBlockPos();
        state.level = blockEntity.getLevel();
        BlockState st = blockEntity.getBlockState();
        Direction f = (Direction)st.getValue(CoffeeTableBlock.FACING);
        state.yaw = switch (f) {
            default -> 0.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> 270.0f;
        };
        ItemStack stack = blockEntity.getItem();
        if (stack.isEmpty()) {
            state.itemStackRenderState.clear();
            return;
        }
        this.itemModelResolver.updateForTopItem(state.itemStackRenderState, blockEntity.getItem(), ItemDisplayContext.FIXED, blockEntity.getLevel(), null, 0);
    }

    public void submit(CoffeeTableRenderState state, PoseStack pose, SubmitNodeCollector queue, CameraRenderState cameraState) {
        pose.pushPose();
        pose.translate(0.5f, 0.6f, 0.5f);
        pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(state.yaw));
        pose.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        pose.scale(0.5f, 0.5f, 0.5f);
        state.itemStackRenderState.submit(pose, queue, this.getLightLevel(state.level, state.pos), OverlayTexture.NO_OVERLAY, 0);
        pose.popPose();
    }

    private int getLightLevel(Level level, BlockPos pos) {
        int bLight = level.getBrightness(LightLayer.BLOCK, pos);
        int sLight = level.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)bLight, (int)sLight);
    }
}

