/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.base;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.BlockModelBakingContext;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ItemModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.data.BaseModelData;
import com.supermartijn642.fusion.model.types.base.BaseBakedModel;
import com.supermartijn642.fusion.model.types.base.BaseItemModel;
import com.supermartijn642.fusion.model.types.base.BaseModelDataImpl;
import com.supermartijn642.fusion.model.types.base.BaseModelElement;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.SimpleUnbakedGeometry;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.NeoForgeModelProperties;
import org.jetbrains.annotations.Nullable;

public class BaseModelType
implements ModelType<BaseModelData> {
    @Override
    public Collection<ResourceLocation> getModelDependencies(BaseModelData data) {
        return data.getParents();
    }

    @Override
    @Nullable
    public UnbakedModel getAsVanillaModel(BaseModelData data) {
        return data.getVanillaModel();
    }

    @Override
    public List<ResourceLocation> getParentModels(BaseModelData data) {
        return data.getParents();
    }

    @Override
    public BlockStateModel bakeBlockModel(BlockModelBakingContext context, BaseModelData data) {
        ((BaseModelDataImpl)data).validateParents(context);
        List<BaseModelQuad> quads = ((BaseModelDataImpl)data).bakeQuads(context);
        boolean ambientOcclusion = ((BaseModelDataImpl)data).findProperty(context, UnbakedModel::ambientOcclusion, true);
        TextureAtlasSprite particleSprite = context.getTexture(((BaseModelDataImpl)data).findParticleSprite(context));
        RenderTypeGroup neoforgeRenderTypeGroup = (RenderTypeGroup)context.getNeoForgeAdditionalProperties().getOptional(NeoForgeModelProperties.RENDER_TYPE);
        ChunkSectionLayer neoforgeRenderType = neoforgeRenderTypeGroup == null ? null : neoforgeRenderTypeGroup.block();
        return new BaseBakedModel(quads, ambientOcclusion, particleSprite, neoforgeRenderType);
    }

    @Override
    public ItemModel bakeItemModel(ItemModelBakingContext context, BaseModelData data) {
        ((BaseModelDataImpl)data).validateParents(context);
        List<BaseModelQuad> quads = ((BaseModelDataImpl)data).bakeQuads(context);
        boolean usesBlockLight = ((BaseModelDataImpl)data).findProperty((BlockModelBakingContext)context, UnbakedModel::guiLight, UnbakedModel.GuiLight.SIDE).lightLikeBlock();
        TextureAtlasSprite particleSprite = context.getTexture(((BaseModelDataImpl)data).findParticleSprite(context));
        ItemTransforms transforms = new ItemTransforms(((BaseModelDataImpl)data).findItemTransform(context, ItemDisplayContext.THIRD_PERSON_LEFT_HAND), ((BaseModelDataImpl)data).findItemTransform(context, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND), ((BaseModelDataImpl)data).findItemTransform(context, ItemDisplayContext.FIRST_PERSON_LEFT_HAND), ((BaseModelDataImpl)data).findItemTransform(context, ItemDisplayContext.FIRST_PERSON_RIGHT_HAND), ((BaseModelDataImpl)data).findItemTransform(context, ItemDisplayContext.HEAD), ((BaseModelDataImpl)data).findItemTransform(context, ItemDisplayContext.GUI), ((BaseModelDataImpl)data).findItemTransform(context, ItemDisplayContext.GROUND), ((BaseModelDataImpl)data).findItemTransform(context, ItemDisplayContext.FIXED), ((BaseModelDataImpl)data).findItemTransform(context, ItemDisplayContext.ON_SHELF));
        RenderTypeGroup neoforgeRenderTypeGroup = (RenderTypeGroup)context.getNeoForgeAdditionalProperties().getOptional(NeoForgeModelProperties.RENDER_TYPE);
        RenderType neoforgeRenderType = neoforgeRenderTypeGroup == null ? null : neoforgeRenderTypeGroup.entity();
        return new BaseItemModel(context.getTintSources(), quads, new ModelRenderProperties(usesBlockLight, particleSprite, transforms), neoforgeRenderType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BaseModelData deserialize(JsonObject json) throws JsonParseException {
        List vanillaElements;
        BlockModel model = (BlockModel)DefaultModelTypes.VANILLA.deserialize(json);
        if (json.has("parent") && json.has("parents")) {
            throw new JsonParseException("Model can only have either 'parent' or 'parents', not both!");
        }
        List<ResourceLocation> parents = List.of();
        if (json.has("parent")) {
            if (!json.get("parent").isJsonPrimitive() || !json.get("parent").getAsJsonPrimitive().isString()) {
                throw new JsonParseException("Property 'parent' must be a string!");
            }
            String parent = json.get("parent").getAsString();
            if (!IdentifierUtil.isValidIdentifier(parent)) {
                throw new JsonParseException("Property 'parent' must be a valid identifier!");
            }
            parents = List.of(ResourceLocation.parse((String)parent));
        } else if (json.has("parents")) {
            if (!json.get("parents").isJsonArray()) {
                throw new JsonParseException("Property 'parents' must be an array!");
            }
            JsonArray parentArray = json.getAsJsonArray("parents");
            parents = new ArrayList<ResourceLocation>(parentArray.size());
            for (JsonElement element : parentArray) {
                if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                    throw new JsonParseException("Array 'parents' must only contain strings!");
                }
                String parent = element.getAsString();
                if (!IdentifierUtil.isValidIdentifier(parent)) {
                    throw new JsonParseException("Array 'parents' must only contain valid identifiers, not '" + parent + "'!");
                }
                parents.add(ResourceLocation.parse((String)parent));
            }
            if (!parents.isEmpty()) {
                model = new BlockModel(model.geometry(), model.guiLight(), model.ambientOcclusion(), model.transforms(), model.textureSlots(), parents.get(0), model.rootTransform(), model.renderTypeGroup(), model.partVisibility());
            }
        }
        List<BaseModelElement> elements = List.of();
        UnbakedGeometry unbakedGeometry = model.geometry();
        if (!(unbakedGeometry instanceof SimpleUnbakedGeometry)) return new BaseModelDataImpl(model, parents, elements);
        SimpleUnbakedGeometry simpleUnbakedGeometry = (SimpleUnbakedGeometry)unbakedGeometry;
        try {
            List list;
            vanillaElements = list = simpleUnbakedGeometry.elements();
            elements = new ArrayList<BaseModelElement>(vanillaElements.size());
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        for (BlockElement element : vanillaElements) {
            elements.add(new BaseModelElement(element.from(), element.to(), element.faces(), element.rotation(), element.shade(), element.lightEmission()));
        }
        return new BaseModelDataImpl(model, parents, elements);
    }

    @Override
    public JsonObject serialize(BaseModelData value) {
        JsonObject json = DefaultModelTypes.VANILLA.serialize(value.getVanillaModel());
        if (value.getParents().size() > 1) {
            json.remove("parent");
            JsonArray parents = new JsonArray(value.getParents().size());
            value.getParents().forEach(p -> parents.add(p.toString()));
            json.add("parents", (JsonElement)parents);
        }
        return json;
    }
}

