/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import com.google.common.base.Suppliers;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.model.types.connecting.ConnectingBakedModel;
import com.supermartijn642.fusion.model.types.connecting.ConnectingModelQuad;
import com.supermartijn642.fusion.model.types.connecting.OrientedMutableQuad;
import com.supermartijn642.fusion.texture.types.connecting.ConnectingTextureSprite;
import com.supermartijn642.fusion.texture.types.connecting.layouts.ConnectingTextureLayoutHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.RenderTypeHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ConnectingItemModel
implements ItemModel {
    private final List<ItemTintSource> tints;
    private final ModelRenderProperties properties;
    private final List<Pair<Optional<RenderType>, List<BakedQuad>>> mesh;
    private final Supplier<Vector3f[]> extents;
    private final boolean animated;

    public ConnectingItemModel(List<ItemTintSource> tints, List<ConnectingModelQuad> quads, ModelRenderProperties properties, RenderType neoforgeRenderType) {
        this.tints = tints;
        this.properties = properties;
        this.extents = Suppliers.memoize(() -> BlockModelWrapper.computeExtents(quads.stream().map(BaseModelQuad::bakedQuad).toList()));
        LinkedHashMap<Optional, List> mesh = new LinkedHashMap<Optional, List>();
        OrientedMutableQuad mutableQuad = new OrientedMutableQuad();
        for (ConnectingModelQuad quad : quads) {
            int n = quad.hasConnectingTexture() ? ConnectingTextureLayoutHandler.get(quad.getLayout()).getAuxiliaryQuadCount() : 0;
            for (int quadIndex = 0; quadIndex < n + 1; ++quadIndex) {
                mutableQuad.fillFromBakedQuad(quad.bakedQuad());
                mutableQuad.emissive(quad.emissive());
                Optional<RenderType> renderType = FusionClient.getChunkLayer(quad.renderType()).map(RenderTypeHelper::getEntityRenderType);
                if (renderType.isEmpty() && neoforgeRenderType != null) {
                    renderType = Optional.of(neoforgeRenderType);
                }
                List itemQuads = mesh.computeIfAbsent(renderType, k -> new ArrayList());
                if (quad.hasConnectingTexture()) {
                    mutableQuad.set(ConnectingBakedModel.TextureOrientation.NORMAL_0.vertexIndexPermutation);
                    boolean keepQuad = ConnectingTextureLayoutHandler.get(quad.getLayout()).processItemQuad(quadIndex, mutableQuad, (ConnectingTextureSprite)quad.bakedQuad().sprite());
                    mutableQuad.resetPermutation();
                    if (!keepQuad) continue;
                }
                itemQuads.add(mutableQuad.toBakedQuad());
            }
        }
        this.mesh = mesh.entrySet().stream().map(entry -> Pair.of((Optional)entry.getKey(), (List)entry.getValue())).toList();
        boolean animated = false;
        for (BaseModelQuad baseModelQuad : quads) {
            if (!baseModelQuad.bakedQuad().sprite().contents().isAnimated()) continue;
            animated = true;
            break;
        }
        this.animated = animated;
    }

    public void update(ItemStackRenderState renderState, ItemStack stack, ItemModelResolver modelResolver, ItemDisplayContext displayContext, @Nullable ClientLevel level, @Nullable ItemOwner owner, int i) {
        ItemStackRenderState.FoilType foilType;
        renderState.appendModelIdentityElement((Object)this);
        if (this.animated) {
            renderState.setAnimated();
        }
        ItemStackRenderState.FoilType foilType2 = stack.hasFoil() ? (BlockModelWrapper.hasSpecialAnimatedTexture((ItemStack)stack) ? ItemStackRenderState.FoilType.SPECIAL : ItemStackRenderState.FoilType.STANDARD) : (foilType = null);
        if (foilType != null) {
            renderState.setAnimated();
            renderState.appendModelIdentityElement((Object)foilType);
        }
        int tints = this.tints.size();
        int[] tintValues = new int[tints];
        for (int j = 0; j < tints; ++j) {
            int tint;
            tintValues[j] = tint = this.tints.get(j).calculate(stack, level, owner == null ? null : owner.asLivingEntity());
            renderState.appendModelIdentityElement((Object)tint);
        }
        for (Pair<Optional<RenderType>, List<BakedQuad>> pair : this.mesh) {
            ItemStackRenderState.LayerRenderState layer = renderState.newLayer();
            if (foilType != null) {
                layer.setFoilType(foilType);
            }
            System.arraycopy(tintValues, 0, layer.prepareTintLayers(tints), 0, tintValues.length);
            layer.setExtents(this.extents);
            this.properties.applyToLayer(layer, displayContext);
            layer.prepareQuadList().addAll((Collection)pair.right());
            layer.setRenderType(pair.left().orElseGet(() -> ItemBlockRenderTypes.getRenderType((ItemStack)stack)));
        }
    }
}

